package game.player;

import game.Constants;
import game.Game;
import game.actor.MovementDirection;
import game.actor.Pacman;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.Point2D;

/**
 * Class that extends Player to provide added functionality for the player
 * controlling the Pacman from the keyboard
 * 
 * @author Alec Berntson
 */
public class LocalPlayer extends Player implements KeyListener, Constants {

	private Pacman pacman;

	/**
	 * Constructs a new LocalPlayer.
	 * 
	 * @param game
	 *           a reference to the Game object
	 */
	public LocalPlayer(Game game) {
		super(game);
		pacman = new Pacman(100, new Point2D.Double(14*CELL, 23*CELL), pacmanImageNames);
	}

	public Pacman getPacman() {
		return pacman;
	}

	public void move(double dt) {
		pacman.move(dt);
	}
	/**
	 * This code is called when a key event is generated because the user pressed a key
	 */
	public void keyPressed(KeyEvent k) {
		switch (k.getKeyCode()) {
		case (KeyEvent.VK_KP_DOWN):
		case (KeyEvent.VK_DOWN):
			pacman.addDirection(MovementDirection.SOUTH);
		break;
		case (KeyEvent.VK_KP_UP):
		case (KeyEvent.VK_UP):
			pacman.addDirection(MovementDirection.NORTH);
		break;
		case (KeyEvent.VK_KP_RIGHT):
		case (KeyEvent.VK_RIGHT):
			pacman.addDirection(MovementDirection.EAST);
		break;
		case (KeyEvent.VK_KP_LEFT):
		case (KeyEvent.VK_LEFT):
			pacman.addDirection(MovementDirection.WEST);
		break;
		}
	}

	public void keyTyped(KeyEvent k) {}
	public void keyReleased(KeyEvent k) {}
}
