package game.player;

import game.Constants;
import game.Game;
import game.actor.Ghost;
import game.actor.MovementDirection;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;

/**
 * This class represents the ghosts, which are controlled by the program.
 */
public class AIPlayer extends Player implements Constants {

	List<Ghost> ghosts = new ArrayList<Ghost>();
	Timer timer = new Timer(false);
	Random rand = new Random();
   
   final int calculationInterval = 2000; // new path calculation interval

	public AIPlayer(Game game, game.map.PacmanMap map) {
		super(game);
	
		//initialize ghosts
		ghosts.add(new Ghost("blinky", 100, new Point2D.Double(12*CELL, 11*CELL), blinkyImageNames));
		ghosts.add(new Ghost("pinky", 85, new Point2D.Double(13*CELL, 11*CELL), pinkyImageNames));
		ghosts.add(new Ghost("inky", 70, new Point2D.Double(14*CELL, 11*CELL), inkyImageNames));
		ghosts.add(new Ghost("clyde", 55, new Point2D.Double(15*CELL, 11*CELL), clydeImageNames));
		timer.scheduleAtFixedRate(new MoveGhostTask(), calculationInterval, calculationInterval);
	}

	public void move(double dt) {
		for (Ghost g : ghosts) {
			g.move(dt);
		}
	}

	public List<Ghost> getActorList() {
		return ghosts;
	}

	class MoveGhostTask extends TimerTask {

		public void run() {
			moveGhosts();
		}

		/**
		 * YOUR CODE GOES HERE!!!!!!
		 * Write the code to move the ghosts so that they chase pacman.
		 * You can use your graph shortestPath algorithm to find the best
		 * route to pacman. (game.getMap().getGraph())
		 * Use ghost.addDirection(direction_to_move) to tell the ghosts which way to go
		 *
		 */
		protected void moveGhosts(){
		   for (Ghost ghost : ghosts) {
		      // for now, pick a random direction
		      MovementDirection md = MovementDirection.values()[rand.nextInt(4)];
		      ghost.addDirection(md);
		   }
		}
	}
}
