package game.actor;

import java.awt.geom.Point2D;
/**
 * the class to represent the user controlled hero of the game
 * @author Alec Berntson
 *
 */
public class Pacman extends Actor {

   public Pacman(double speed, Point2D initialLocation, String[][] imagePaths) {
      super("pacman", speed, initialLocation, imagePaths);
   }

   /**
    * use this method to register directional commands. Each time the arrow key
    * is pressed, this method should be called to store the new direction. This
    * method deals with the logic needed to determine what currentDirection and
    * nextDirection should be.
    * 
    * @param newDirection
    */
   public void addDirection(MovementDirection newDirection) {
      // if we are not moving now, set both directions to be newDirection
      if (currentDirection == MovementDirection.NONE) {
         currentDirection = newDirection;
         nextDirection = currentDirection;
         lastInterection = new Point2D.Double(-1, -1);
      }
      // if newDirection is the same as our current direction, cancel the change
      // (set nextDirection = current)
      else if (newDirection == currentDirection) {
         nextDirection = newDirection;
      }
      // if we are turning around, set both
      else if (MovementDirection.isOpposite(currentDirection, newDirection)) {
         currentDirection = newDirection;
         nextDirection = currentDirection;
         lastInterection = new Point2D.Double(-1, -1);

      }
      // otherwise register to turn 90 deg at the next intersection
      else { // newDirection must be perpendicular
         nextDirection = newDirection;
      }
   }
}
