package a4;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;

public class Server extends Host {
   
   Server() throws IOException {
      this(100, 200);
   }
   
   Server(int x, int y) throws IOException {
      super(DEFAULT_PORT, x, y);
   }
   
   /*
    * button and menu handlers
    */
   public void start() {
      super.start();
      gui.setConnectedState();
   }
   
   void refresh() {
      gui.message("Requesting file list refresh from clients");
      gui.clearFiles();
      synchronized (clients) {
         Message.refresh(clients);
      }
      //when responses come back, they will be appended to file list
   }

   /*
    * message handlers
    */
   public void messageReceived(Connection connection, Message message) {
      switch (message.getCommand()) {
      case REFRESH:
         refresh();
         //wait for messages to return, then send file list
         new DelayedFileListMessage(connection).schedule();
         break;
      case FILELIST:
         //response from clients to refresh request
         gui.appendFiles(message.getArgs());
         gui.message("File list refreshed");
         break;
      default:      
         Message.sendError(connection, "Unrecognized message");
      }
   }

   class DelayedFileListMessage extends Timer {
      static final long REFRESH_DELAY = 3000;
      final Connection connection;

      DelayedFileListMessage(Connection connection) {
         super(true); //run as daemon
         this.connection = connection;
      }

      void schedule() {
         super.schedule(new TimerTask() {
            public void run() {
               Message.sendFileList(connection, gui.getListData());
            }
         }, REFRESH_DELAY);
      }
   }

}
