package a4;

import java.net.InetAddress;

public class RemoteFile {
   
   private InetAddress address;
   private String ip;
   private int port;
   private String fileName;
   private String hostName;
   
   RemoteFile(String s) throws IllegalArgumentException {
      //parse
      int j0 = s.indexOf('/');
      int j1 = s.indexOf(':');
      int j2 = s.indexOf(' ');
      if (j0 < 0 || j1 < j0 || j2 < j1) throw new IllegalArgumentException();
      hostName = s.substring(0, j0);
      ip = s.substring(j0 + 1, j1);
      fileName = s.substring(j2 + 1);
      try {
         port = Integer.parseInt(s.substring(j1 + 1, j2));
         address = InetAddress.getByName(ip);
      } catch (Exception e) {
         throw new IllegalArgumentException();
      }
   }
   
   InetAddress getAddress() {
      return address;
   }

   String getIP() {
      return ip;
   }

   int getPort() {
      return port;
   }

   String getFileName() {
      return fileName;
   }
   
   String getHostName() {
      return hostName;
   }
   
   String getSocketAddress() {
      return hostName + address + ":" + port;
   }
   
   public String toString() {
      return getSocketAddress() + " " + fileName;
   }

}
