package a4;

import java.awt.Point;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.HashSet;
import java.util.Set;

public abstract class Host implements MessageListener {
   
   // if you have any problems with port binding, change this setting:
   static final int DEFAULT_PORT = 5000;
   
   protected final int listenerPort;
   protected final ServerSocket socket;
   protected final Set<Connection> clients = new HashSet<Connection>();
   protected final GUI gui;
   
   public Host(int port, int x, int y) throws IOException {
      listenerPort = port;
      socket = new ServerSocket(port);
      gui = new GUI(this, new Point(x, y));
   }

   private Thread serverThread = new Thread() {
      public void run() {
         while (true) {
            try {
               Connection connection = new Connection(socket.accept());
               connection.addMessageListener(Host.this);
               synchronized (clients) {
                  clients.add(connection);
               }
               connection.start();
               gui.message("Client " + connection.getAddress() + " connected");
            } catch (IOException e) {
               if (socket.isClosed()) break;
               gui.error("Server error", "Cannot open connection");
            }
         }
      }
   };

   public void start() {
      if (serverThread.isAlive()) return;
      serverThread.start();
   }
   
   public void close() {
      try {
         socket.close();
      } catch (Exception e) {}
   }
   
   abstract void refresh();
}
