/*
 * Decompiled with CFR 0.152.
 */
package a4;

import a4.Connection;
import a4.Host;
import a4.Message;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public class Server
extends Host {
    private Set<Connection> droppedClients = new HashSet<Connection>();

    Server() throws IOException {
        this(100, 200);
    }

    Server(int x, int y) throws IOException {
        super(5000, x, y);
    }

    public void start() {
        super.start();
        this.gui.setConnectedState();
        new Ping().start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refresh() {
        this.gui.message("Requesting file list refresh from clients");
        this.gui.clearFiles();
        Set set = this.clients;
        synchronized (set) {
            Message.refresh(this.clients);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(Connection connection, Message message) {
        switch (message.getCommand()) {
            case REFRESH: {
                this.refresh();
                new DelayedFileListMessage(connection).schedule();
                break;
            }
            case FILELIST: {
                this.gui.appendFiles(message.getArgs());
                this.gui.message("File list refreshed");
                break;
            }
            case PING: {
                Set<Connection> set = this.droppedClients;
                synchronized (set) {
                    this.droppedClients.remove(connection);
                    break;
                }
            }
            default: {
                Message.sendError(connection, "Unrecognized message");
            }
        }
    }

    class DelayedFileListMessage
    extends Timer {
        static final long REFRESH_DELAY = 3000L;
        final Connection connection;

        DelayedFileListMessage(Connection connection) {
            super(true);
            this.connection = connection;
        }

        void schedule() {
            super.schedule(new TimerTask(){

                public void run() {
                    Message.sendFileList(DelayedFileListMessage.this.connection, ((DelayedFileListMessage)DelayedFileListMessage.this).Server.this.gui.getListData());
                }
            }, 3000L);
        }
    }

    class Ping
    extends Timer {
        static final long REFRESH_DELAY = 30000L;

        Ping() {
            super(true);
        }

        void start() {
            super.schedule(new TimerTask(){

                public void run() {
                    boolean droppedOne = false;
                    for (Connection c : Server.this.droppedClients) {
                        c.close();
                        droppedOne = true;
                    }
                    if (droppedOne) {
                        Server.this.refresh();
                    }
                    Server.this.droppedClients = (Set)((HashSet)((Ping)Ping.this).Server.this.clients).clone();
                    Message.ping(((Ping)Ping.this).Server.this.clients);
                }
            }, 30000L, 30000L);
        }
    }
}

