/*
 * Decompiled with CFR 0.152.
 */
package a4;

import java.net.InetAddress;

public class RemoteFile {
    private InetAddress address;
    private String ip;
    private int port;
    private String fileName;
    private String hostName;

    RemoteFile(String s) throws IllegalArgumentException {
        int j0 = s.indexOf(47);
        int j1 = s.indexOf(58);
        int j2 = s.indexOf(32);
        if (j0 < 0 || j1 < j0 || j2 < j1) {
            throw new IllegalArgumentException();
        }
        this.hostName = s.substring(0, j0);
        this.ip = s.substring(j0 + 1, j1);
        this.fileName = s.substring(j2 + 1);
        try {
            this.port = Integer.parseInt(s.substring(j1 + 1, j2));
            this.address = InetAddress.getByName(this.ip);
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
    }

    InetAddress getAddress() {
        return this.address;
    }

    String getIP() {
        return this.ip;
    }

    int getPort() {
        return this.port;
    }

    String getFileName() {
        return this.fileName;
    }

    String getHostName() {
        return this.hostName;
    }

    String getSocketAddress() {
        return String.valueOf(this.hostName) + this.address + ":" + this.port;
    }

    public String toString() {
        return String.valueOf(this.getSocketAddress()) + " " + this.fileName;
    }

    public Object[] toTableRow() {
        Object[] row = new Object[]{this.getHostName(), this.getIP(), new Integer(this.getPort()), this.getFileName()};
        return row;
    }
}

