/*
 * Decompiled with CFR 0.152.
 */
package a4;

import a4.Command;
import a4.Connection;
import java.net.URLDecoder;
import java.net.URLEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Message {
    private final Command command;
    private final String[] args;

    private Message(Command command, String ... args) {
        if (command == null || args == null) {
            throw new NullPointerException();
        }
        int i = 0;
        while (i < args.length) {
            if (args[i] == null) {
                throw new NullPointerException();
            }
            ++i;
        }
        this.command = command;
        this.args = args;
    }

    public Command getCommand() {
        return this.command;
    }

    public String[] getArgs() {
        return this.args;
    }

    public String toString() {
        StringBuilder s = new StringBuilder(this.command.toString());
        String[] stringArray = this.args;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String arg = stringArray[n];
            s.append("\t");
            s.append(Message.encode(arg.toString()));
            ++n;
        }
        return s.toString();
    }

    private static String encode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (Exception e) {
            return s;
        }
    }

    private static String decode(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (Exception e) {
            return s;
        }
    }

    public static Message parse(String s) {
        String[] data = s.split("[\\t]+");
        if (data.length < 1) {
            throw new IllegalArgumentException();
        }
        Command type = Command.valueOf(data[0].toUpperCase());
        String[] args = new String[data.length - 1];
        int i = 1;
        while (i < data.length) {
            args[i - 1] = Message.decode(data[i]);
            ++i;
        }
        return new Message(type, args);
    }

    public static void refresh(Connection remoteConnection) {
        remoteConnection.send(new Message(Command.REFRESH, new String[0]));
    }

    public static void refresh(Iterable<Connection> remoteConnections) {
        for (Connection remoteConnection : remoteConnections) {
            Message.refresh(remoteConnection);
        }
    }

    public static void requestDownload(Connection remoteConnection, String file) {
        remoteConnection.send(new Message(Command.DOWNLOAD, file));
    }

    public static void sendFileList(Connection remoteConnection, String[] list) {
        remoteConnection.send(new Message(Command.FILELIST, list));
    }

    public static void sendText(Connection remoteConnection, String text) {
        remoteConnection.send(new Message(Command.TEXT, text));
    }

    public static void sendError(Connection remoteConnection, String message) {
        remoteConnection.send(new Message(Command.ERROR, message));
    }

    public static void sendDownloadReady(Connection remoteConnection, String file) {
        remoteConnection.send(new Message(Command.READY, file));
    }

    public static void sendDone(Connection remoteConnection) {
        remoteConnection.send(new Message(Command.DONE, new String[0]));
    }

    public static void ping(Connection remoteConnection) {
        remoteConnection.send(new Message(Command.PING, new String[0]));
    }

    public static void ping(Iterable<Connection> remoteConnections) {
        for (Connection remoteConnection : remoteConnections) {
            Message.ping(remoteConnection);
        }
    }
}

