/*
 * Decompiled with CFR 0.152.
 */
package a4;

import a4.Connection;
import a4.GUI;
import a4.MessageListener;
import java.awt.Point;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.HashSet;
import java.util.Set;

public abstract class Host
implements MessageListener {
    static final int DEFAULT_PORT = 5000;
    protected final int listenerPort;
    protected final ServerSocket socket;
    protected final Set<Connection> clients = new HashSet<Connection>();
    protected final GUI gui;
    private Thread serverThread = new Thread(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Connection connection = new Connection(Host.this.socket.accept());
                        connection.addMessageListener(Host.this);
                        Set<Connection> set = Host.this.clients;
                        synchronized (set) {
                            Host.this.clients.add(connection);
                        }
                        connection.start();
                        Host.this.gui.message("Client " + connection.getAddress() + " connected");
                    }
                }
                catch (IOException e) {
                    if (!Host.this.socket.isClosed()) {
                        Host.this.gui.error("Server error", "Cannot open connection");
                        continue;
                    }
                    return;
                }
                break;
            }
        }
    };

    public Host(int port, int x, int y) throws IOException {
        this.listenerPort = port;
        this.socket = new ServerSocket(port);
        this.gui = new GUI(this, new Point(x, y));
    }

    public void start() {
        if (this.serverThread.isAlive()) {
            return;
        }
        this.serverThread.start();
    }

    public void close() {
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    abstract void refresh();
}

