/*
 * Decompiled with CFR 0.152.
 */
package a4;

import a4.Client;
import a4.Host;
import a4.MyTableModel;
import a4.RemoteFile;
import a4.Server;
import a4.TableSorter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Enumeration;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class GUI {
    final JFrame frame = new JFrame();
    private final MyTableModel tableModel = new MyTableModel();
    private final TableSorter sorter = new TableSorter(this.tableModel);
    private final JTable table = new JTable(this.sorter);
    private final JLabel messageArea;
    private final JTextField textField = new JTextField(20);
    private final HelpDialog helpDialog = new HelpDialog();
    private final Host host;
    public static final String DEFAULT_IP = "127.1.1.0";
    private final AbstractAction startAction = new AbstractAction("Start"){

        public void actionPerformed(ActionEvent e) {
            ((Server)GUI.this.host).start();
        }
    };
    private final AbstractAction connectAction = new AbstractAction("Connect..."){

        public void actionPerformed(ActionEvent e) {
            ((Client)GUI.this.host).connect();
        }
    };
    private final AbstractAction downloadAction = new AbstractAction("Download"){

        public void actionPerformed(ActionEvent e) {
            ((Client)GUI.this.host).download();
        }
    };
    private final AbstractAction selectDirectoryAction = new AbstractAction("Select Directory"){

        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            chooser.setCurrentDirectory(((Client)((GUI)GUI.this).host).workingDirectory);
            chooser.setFileSelectionMode(1);
            if (chooser.showOpenDialog(GUI.this.frame) == 0) {
                ((Client)((GUI)GUI.this).host).workingDirectory = chooser.getSelectedFile().isDirectory() ? chooser.getSelectedFile() : chooser.getCurrentDirectory();
            }
        }
    };
    private final AbstractAction searchAction = new AbstractAction("Search"){

        public void actionPerformed(ActionEvent e) {
            GUI.this.search(GUI.this.textField.getText());
        }
    };
    private final AbstractAction refreshAction = new AbstractAction("Refresh"){

        public void actionPerformed(ActionEvent e) {
            GUI.this.host.refresh();
        }
    };

    public GUI(Host host, Point location) {
        this.host = host;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.frame.setDefaultCloseOperation(3);
        this.frame.setTitle(this.isClient() ? "Client" : "Server");
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("Action");
        if (this.isClient()) {
            fileMenu.add(new JMenuItem(this.connectAction));
            fileMenu.add(new JMenuItem(this.refreshAction));
            fileMenu.add(new JMenuItem(this.selectDirectoryAction));
            fileMenu.add(new JMenuItem(this.downloadAction));
        } else {
            fileMenu.add(new JMenuItem(this.startAction));
            fileMenu.add(new JMenuItem(this.refreshAction));
        }
        fileMenu.addSeparator();
        JMenuItem byeMenuItem = new JMenuItem("Quit");
        byeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUI.this.frame.dispose();
            }
        });
        fileMenu.add(byeMenuItem);
        menuBar.add(fileMenu);
        JMenu optionsMenu = new JMenu("Options");
        JMenu colorMenu = new JMenu("Color");
        ButtonGroup colorGroup = new ButtonGroup();
        ColorRadioButton c = new ColorRadioButton("White/Black", Color.white, Color.black);
        this.setColors(c.background, c.foreground);
        c.setSelected(true);
        colorGroup.add(c);
        colorGroup.add(new ColorRadioButton("Ithaca Sunset", new Color(204, 204, 204), new Color(0, 0, 0)));
        colorGroup.add(new ColorRadioButton("Spruce Forest", new Color(0, 45, 45), new Color(32, 196, 112)));
        colorGroup.add(new ColorRadioButton("Ocean Breeze", new Color(72, 200, 200), new Color(0, 20, 86)));
        colorGroup.add(new ColorRadioButton("681 Web Site", new Color(51, 51, 85), new Color(255, 255, 153)));
        colorGroup.add(new ColorRadioButton("682 Web Site", new Color(204, 204, 153), new Color(153, 0, 0)));
        colorGroup.add(new ColorRadioButton("Cornell", new Color(255, 255, 255), new Color(179, 27, 27)));
        colorGroup.add(new ColorRadioButton("Custom...", Color.lightGray, Color.lightGray));
        Enumeration<AbstractButton> e = colorGroup.getElements();
        while (e.hasMoreElements()) {
            colorMenu.add(e.nextElement());
        }
        optionsMenu.add(colorMenu);
        menuBar.add(optionsMenu);
        JMenu helpMenu = new JMenu("Help");
        JMenuItem item = new JMenuItem("Get help...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GUI.this.helpDialog.display();
            }
        });
        helpMenu.add(item);
        helpMenu.addSeparator();
        item = new JMenuItem("About...", 65);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                String[] aboutMsg = new String[]{"211ster Version 1.0", "Copyright \u00a9 2007 Cornell University"};
                JOptionPane.showMessageDialog(GUI.this.frame, aboutMsg, "About 211ster", 1);
            }
        });
        helpMenu.add(item);
        menuBar.add(helpMenu);
        this.frame.setJMenuBar(menuBar);
        JPanel toolBar = new JPanel(new FlowLayout(0));
        toolBar.setBackground(Color.lightGray);
        if (this.isClient()) {
            toolBar.add(new JButton(this.connectAction));
            toolBar.add(new JButton(this.refreshAction));
            toolBar.add(new JButton(this.downloadAction));
            toolBar.add(this.textField);
            toolBar.add(new JButton(this.searchAction));
        } else {
            toolBar.add(new JButton(this.startAction));
            toolBar.add(new JButton(this.refreshAction));
        }
        this.frame.add((Component)toolBar, "North");
        this.table.setFont(Font.decode("Courier"));
        this.table.setSelectionMode(0);
        this.sorter.setTableHeader(this.table.getTableHeader());
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setPreferredSize(new Dimension(500, 100));
        this.frame.add((Component)scrollPane, "Center");
        this.clearFiles();
        this.messageArea = new JLabel("", 2);
        this.messageArea.setBackground(Color.darkGray);
        this.frame.add((Component)this.messageArea, "South");
        this.clearMessage();
        this.setDisconnectedState();
        this.frame.pack();
        this.frame.setLocation(location);
        this.frame.setVisible(true);
    }

    void setConnectedState() {
        this.startAction.setEnabled(false);
        this.connectAction.setEnabled(false);
        this.refreshAction.setEnabled(true);
        this.downloadAction.setEnabled(true);
    }

    void setDisconnectedState() {
        this.startAction.setEnabled(true);
        this.connectAction.setEnabled(true);
        this.refreshAction.setEnabled(false);
        this.downloadAction.setEnabled(false);
    }

    private void setColors(Color b, Color f) {
        this.table.setBackground(b);
        this.table.setForeground(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearFiles() {
        MyTableModel myTableModel = this.tableModel;
        synchronized (myTableModel) {
            this.tableModel.clearData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void appendFiles(String[] v) {
        MyTableModel myTableModel = this.tableModel;
        synchronized (myTableModel) {
            this.tableModel.appendData(v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void displayFiles(String[] v) {
        MyTableModel myTableModel = this.tableModel;
        synchronized (myTableModel) {
            this.tableModel.clearData();
            this.tableModel.appendData(v);
        }
    }

    void search(String s) {
        int i = 0;
        while (i < this.tableModel.getRowCount()) {
            String t = this.tableModel.getRow(this.sorter.modelIndex(i)).toString();
            if (t.indexOf(s) >= 0) {
                this.table.changeSelection(i, 0, false, false);
                this.clearMessage();
                return;
            }
            ++i;
        }
        this.table.clearSelection();
        this.message("Not found");
    }

    public int convertRowIndexToView(int i) {
        int j = 0;
        while (j < this.sorter.getRowCount()) {
            if (this.sorter.modelIndex(j) == i) {
                return j;
            }
            ++j;
        }
        throw new IndexOutOfBoundsException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getListData() {
        String[] s;
        int i = 0;
        MyTableModel myTableModel = this.tableModel;
        synchronized (myTableModel) {
            Vector<RemoteFile> data = this.tableModel.getData();
            s = new String[data.size()];
            for (RemoteFile rf : data) {
                s[i++] = rf.toString();
            }
        }
        return s;
    }

    String getSelectedFile() {
        int index = this.table.getSelectedRow();
        if (index == -1) {
            return null;
        }
        index = this.sorter.modelIndex(index);
        return this.tableModel.getRow(index).toString();
    }

    public void message(String s) {
        this.messageArea.setText(" " + s);
    }

    private void clearMessage() {
        this.message("");
    }

    private boolean isClient() {
        return this.host instanceof Client;
    }

    String getServerIP() {
        return (String)JOptionPane.showInputDialog(this.frame, "Enter the IP address of the server", "Enter Server IP", -1, null, null, DEFAULT_IP);
    }

    void error(String title, String message) {
        JOptionPane.showMessageDialog(this.frame, message, title, 0);
    }

    private class ColorRadioButton
    extends JRadioButtonMenuItem
    implements ActionListener {
        Color background;
        Color foreground;

        ColorRadioButton(String s, Color b, Color f) {
            super(s);
            this.background = b;
            this.foreground = f;
            this.setActionCommand(s);
            this.addActionListener(this);
            if (!s.equals("Custom...")) {
                this.setIcon(this.createIcon(b, f));
            }
        }

        Icon createIcon(Color background, Color foreground) {
            BufferedImage image = new BufferedImage(12, 12, 1);
            Graphics graphics = ((Image)image).getGraphics();
            graphics.setColor(background);
            graphics.fillRect(0, 0, 12, 12);
            graphics.setColor(foreground);
            graphics.fillRect(5, 0, 2, 12);
            graphics.fillRect(0, 5, 12, 2);
            return new ImageIcon(image);
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("Custom...")) {
                Color bc = JColorChooser.showDialog(GUI.this.frame, "Choose Background Color", this.background);
                if (bc == null) {
                    return;
                }
                Color fc = JColorChooser.showDialog(GUI.this.frame, "Choose Foreground Color", this.foreground);
                if (fc == null) {
                    return;
                }
                this.background = bc;
                this.foreground = fc;
                this.setIcon(this.createIcon(bc, fc));
            }
            GUI.this.setColors(this.background, this.foreground);
        }
    }

    private class HelpDialog
    extends JDialog {
        BufferedImage logo;
        int width;
        int height;

        HelpDialog() {
            super((Frame)GUI.this.frame, "Help!");
            this.logo = null;
            this.width = 200;
            this.height = 200;
            try {
                this.logo = ImageIO.read(ClassLoader.getSystemResourceAsStream("a4/munch.gif"));
                this.width = this.logo.getWidth();
                this.height = this.logo.getHeight();
            }
            catch (Exception e) {
                this.add(new JLabel("Help!", 0));
            }
            this.setSize(this.width, this.height);
        }

        void display() {
            this.setLocation(GUI.this.frame.getX() + 100, GUI.this.frame.getY() + 50);
            this.setVisible(true);
        }

        public void paint(Graphics graphics) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
            if (this.logo != null) {
                graphics.drawImage(this.logo, 0, 0, this.getBackground(), null);
            }
        }
    }
}

