/*
 * Decompiled with CFR 0.152.
 */
package a4;

import a4.Message;
import a4.MessageListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class Connection
extends Thread {
    private final Socket socket;
    private final PrintWriter out;
    private final BufferedReader in;
    private final List<MessageListener> listeners = new ArrayList<MessageListener>();

    public Connection(Socket socket) throws IOException {
        this.socket = socket;
        this.out = new PrintWriter((Writer)new OutputStreamWriter(socket.getOutputStream(), "UTF-8"), true);
        this.in = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
    }

    public Connection(InetAddress address, int port) throws IOException {
        this(new Socket(address, port));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message m) {
        if (m == null) {
            throw new NullPointerException();
        }
        PrintWriter printWriter = this.out;
        synchronized (printWriter) {
            this.out.println(m);
        }
    }

    public Message recv() throws IOException {
        return this.recv(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Message recv(int timeout) throws IOException {
        String s = null;
        BufferedReader bufferedReader = this.in;
        synchronized (bufferedReader) {
            int oldTimeout = this.setTimeout(timeout);
            this.in.mark(1024);
            try {
                try {
                    s = this.in.readLine();
                }
                catch (SocketTimeoutException e) {
                    this.in.reset();
                    this.setTimeout(oldTimeout);
                    return null;
                }
            }
            finally {
                this.setTimeout(oldTimeout);
            }
        }
        if (s == null) {
            throw new IOException();
        }
        try {
            return Message.parse(s);
        }
        catch (Exception e) {
            throw new IOException();
        }
    }

    public void close() {
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageListener(MessageListener l) {
        List<MessageListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (!this.socket.isClosed()) {
                Message m = this.recv();
                List<MessageListener> list = this.listeners;
                synchronized (list) {
                    for (MessageListener l : this.listeners) {
                        SwingUtilities.invokeLater(new MessageNotifier(l, m));
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int setTimeout(int timeout) {
        int oldTimeout = 0;
        try {
            oldTimeout = this.socket.getSoTimeout();
            this.socket.setSoTimeout(timeout);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return oldTimeout;
    }

    String getIP() {
        return this.socket.getInetAddress().toString();
    }

    int getPort() {
        return this.socket.getPort();
    }

    String getAddress() {
        return this.socket.getRemoteSocketAddress().toString();
    }

    String getLocalAddress() {
        try {
            return InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException uhe) {
            return this.socket.getLocalAddress().toString();
        }
    }

    private class MessageNotifier
    implements Runnable {
        private final MessageListener listener;
        private final Message message;

        public MessageNotifier(MessageListener listener, Message message) {
            this.listener = listener;
            this.message = message;
        }

        public void run() {
            this.listener.messageReceived(Connection.this, this.message);
        }
    }
}

