/*
 * Decompiled with CFR 0.152.
 */
package a4;

import a4.Command;
import a4.Connection;
import a4.Host;
import a4.Message;
import a4.RemoteFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Vector;

public class Client
extends Host {
    Connection serverConnection;
    String clientID;
    File workingDirectory = new File(System.getProperty("user.dir"));
    private static /* synthetic */ int[] $SWITCH_TABLE$a4$Command;

    Client(int port) throws IOException {
        this(port, 700, 200);
    }

    Client(int port, int x, int y) throws IOException {
        super(port, x, y);
    }

    void connect() {
        while (true) {
            String serverIP;
            if ((serverIP = this.gui.getServerIP()) == null) {
                return;
            }
            this.gui.message("Connecting to " + serverIP);
            try {
                this.serverConnection = new Connection(InetAddress.getByName(serverIP), 5000);
                this.serverConnection.addMessageListener(this);
                this.serverConnection.start();
            }
            catch (Exception e) {
                this.gui.error("Connection Error", "Error Connecting: " + e.getMessage());
                continue;
            }
            break;
        }
        this.gui.setConnectedState();
        this.clientID = String.valueOf(this.serverConnection.getLocalAddress()) + ":" + this.listenerPort;
        this.gui.message("Connected to " + this.serverConnection.getAddress());
        this.gui.frame.setTitle("Client " + this.clientID);
        super.start();
    }

    Connection connectToPeer(InetAddress peerIP, int port) {
        this.gui.message("Connecting to " + peerIP);
        Connection peer = null;
        try {
            peer = new Connection(peerIP, port);
        }
        catch (IOException e) {
            this.gui.error("Connection Error", "Error Connecting: " + e.getMessage());
            if (peer != null) {
                peer.close();
            }
            return null;
        }
        this.gui.message("Connected to " + peer.getAddress());
        return peer;
    }

    void refresh() {
        this.gui.message("Requesting file list refresh from server");
        Message.refresh(this.serverConnection);
    }

    void download() {
        String file = this.gui.getSelectedFile();
        if (file == null) {
            this.gui.message("Select a file to download");
            return;
        }
        this.gui.message("Requesting download");
        RemoteFile rf = null;
        try {
            rf = new RemoteFile(file);
        }
        catch (IllegalArgumentException iae) {
            this.gui.error("Error", "Unrecognized filename or IP address");
            return;
        }
        Connection p2p = this.connectToPeer(rf.getAddress(), rf.getPort());
        String fileName = rf.getFileName();
        Message.requestDownload(p2p, fileName);
        Message m = null;
        try {
            m = p2p.recv(10000);
            if (m == null) {
                throw new IOException("Transmission timeout");
            }
            if (m != null && !m.getCommand().equals((Object)Command.READY)) {
                throw new IOException("Transmission error, download aborted");
            }
        }
        catch (IOException ioe) {
            this.gui.error("Error", ioe.getMessage());
            p2p.close();
            return;
        }
        this.gui.message("Receiving " + fileName + " from " + p2p.getIP());
        File outFile = new File(this.workingDirectory, fileName);
        if (outFile.exists()) {
            int j = fileName.lastIndexOf(46);
            String name = j < 0 ? fileName : fileName.substring(0, j);
            String tag = j < 0 ? "" : fileName.substring(j);
            j = 1;
            while (outFile.exists()) {
                outFile = new File(this.workingDirectory, String.valueOf(name) + "(" + j + ")" + tag);
                ++j;
            }
        }
        FileWriter dataOut = null;
        try {
            dataOut = new FileWriter(outFile);
            while (true) {
                if ((m = p2p.recv(10000)) == null) {
                    throw new IOException("Transmission timeout");
                }
                if (m.getCommand().equals((Object)Command.DONE)) break;
                if (!m.getCommand().equals((Object)Command.TEXT)) {
                    throw new IOException("Transmission error, download aborted");
                }
                String text = m.getArgs()[0];
                dataOut.write(text);
            }
            dataOut.flush();
            dataOut.close();
            this.gui.message("Download successful");
        }
        catch (IOException ioe) {
            this.gui.error("Error", ioe.getMessage());
        }
        p2p.close();
    }

    public void close() {
        super.close();
        try {
            this.serverConnection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Unable to fully structure code
     */
    public void messageReceived(Connection connection, Message message) {
        switch (Client.$SWITCH_TABLE$a4$Command()[message.getCommand().ordinal()]) {
            case 2: {
                fileList = this.workingDirectory.list(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return new File(dir, name).isFile();
                    }
                });
                i = 0;
                while (i < fileList.length) {
                    fileList[i] = String.valueOf(this.clientID) + " " + fileList[i];
                    ++i;
                }
                Message.sendFileList(this.serverConnection, fileList);
                break;
            }
            case 3: {
                v = new Vector<String>();
                var8_6 = message.getArgs();
                var6_9 = 0;
                var7_11 = var8_6.length;
                while (var6_9 < var7_11) {
                    s = var8_6[var6_9];
                    rf = null;
                    try {
                        rf = new RemoteFile(s);
                    }
                    catch (IllegalArgumentException iae) {
                        ** GOTO lbl27
                    }
                    if (!rf.getSocketAddress().equals(this.clientID)) {
                        v.add(s);
                    }
lbl27:
                    // 4 sources

                    ++var6_9;
                }
                this.gui.displayFiles(v.toArray(new String[0]));
                this.gui.message("File list refreshed");
                break;
            }
            case 4: {
                fileName = message.getArgs()[0];
                this.gui.message("Sending " + fileName + " to " + connection.getIP());
                file = new File(this.workingDirectory, fileName);
                if (!file.exists()) {
                    Message.sendError(connection, "File does not exist");
                    break;
                }
                if (file.isDirectory()) {
                    Message.sendError(connection, "File is a directory");
                    break;
                }
                try {
                    dataIn = new FileReader(file);
                }
                catch (FileNotFoundException fnfe) {
                    Message.sendError(connection, "File does not exist");
                    break;
                }
                Message.sendDownloadReady(connection, fileName);
                buf = new char[128];
                try {
                    while ((bytesRead = dataIn.read(buf)) != -1 && bytesRead != 0) {
                        msg = new String(buf, 0, bytesRead);
                        Message.sendText(connection, msg);
                    }
                    Message.sendDone(connection);
                    dataIn.close();
                    this.gui.message("File successfully sent");
                }
                catch (IOException e) {
                    Message.sendError(connection, "Transmission error, download aborted");
                }
                connection.close();
                break;
            }
            case 1: {
                Message.ping(connection);
                break;
            }
            case 8: {
                this.gui.error("Error", message.getArgs()[0]);
                break;
            }
            default: {
                this.gui.error("Error", "Unrecognized message");
            }
        }
    }

    static /* synthetic */ int[] $SWITCH_TABLE$a4$Command() {
        if ($SWITCH_TABLE$a4$Command != null) {
            return $SWITCH_TABLE$a4$Command;
        }
        int[] nArray = new int[Command.values().length];
        try {
            nArray[Command.DONE.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Command.DOWNLOAD.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Command.ERROR.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Command.FILELIST.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Command.PING.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Command.READY.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Command.REFRESH.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Command.TEXT.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$a4$Command = nArray;
        return nArray;
    }
}

