package a3;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

/**
 * The "rotate 13" codec. Exchanges 'a' with 'n', 'b' with 'o', etc., but does not
 * do any compression.
 * 
 * @author Dexter
 */
public class Rot13 implements Codec {

   public void compress(File input, File output) throws IOException {
      FileInputStream fis = new FileInputStream(input);
      FileOutputStream fos = new FileOutputStream(output);
      for (int b = fis.read(); b != -1; b = fis.read()) {
         if ('a' <= b && b <= 'z') {
            b = ((b - 'a' + 13) % 26) + 'a';
         }
         if ('A' <= b && b <= 'Z') {
            b = ((b - 'A' + 13) % 26) + 'A';
         }
         fos.write(b);
      }
      fis.close();
      fos.flush();
      fos.close();
   }

   public void decompress(File input, File output) throws IOException {
      compress(input, output);
   }
}