package a3;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

/**
 * The identity codec. Just copies the input file to the output file verbatim
 * with no compression.
 * 
 * @author Dexter
 */
public class IdentityCodec implements Codec {

   public void compress(File input, File output) throws IOException {
      FileInputStream fis = new FileInputStream(input);
      FileOutputStream fos = new FileOutputStream(output);
      for (int b = fis.read(); b != -1; b = fis.read()) {
         fos.write(b);
      }
      fis.close();
      fos.flush();
      fos.close();
   }

   public void decompress(File input, File output) throws IOException {
      compress(input, output);
   }
}
