package a3;

import java.io.File;
import java.io.IOException;

/**
 * This interface can be implemented by modules that compress and decompress data.
 * 
 * @author Dexter
 */
public interface Codec {

   /**
    * Compresses data from the input file, writes the compressed data to the
    * output file.
    */
   void compress(File input, File output) throws IOException;

   /**
    * Decompresses data from the input file, writes the decompressed data to the
    * output file.
    */
   void decompress(File input, File output) throws IOException;

}
