package a3;
import java.util.Arrays;
import java.util.NoSuchElementException;

/**
 * ByteString
 * This class is just like String, except that no character
 * translation takes place.
 */

class ByteString {
   private byte[] bytes;

   ByteString(byte[] b) {
      bytes = b;
   }

   ByteString(byte c) {
      bytes = new byte[1];
      bytes[0] = c;
   }

   ByteString(ByteString s) {
      bytes = new byte[s.length()];
      System.arraycopy(s.bytes,0,bytes,0,s.length());
   }
   
   ByteString(ByteString s, byte c) {
      bytes = new byte[s.length() + 1];
      System.arraycopy(s.bytes,0,bytes,0,s.length());
      bytes[s.length()] = c;
   }
   
   ByteString(String s) {
      bytes = s.getBytes();
   }
   
   int length() {
      return bytes.length;
   }
   
   byte byteAt(int index) {
      if (index < 0 || index >= length()) throw new NoSuchElementException();
      return bytes[index];
   }

   void setByteAt(int index, byte value) {
      if (index < 0 || index >= length()) throw new NoSuchElementException();
      bytes[index] = value;
   }

   public boolean equals(Object obj) {
      if (!(obj instanceof ByteString)) return false;
      return Arrays.equals(bytes,((ByteString)obj).bytes);
   }
   
   public int hashCode() {
      return Arrays.hashCode(bytes);
   }
   
   public String toString() {
      return new String(bytes);
   }
   
   long toLong() {
      if (length() != 8) throw new IllegalArgumentException();
      long a = 0;
      for (int i = 0; i < length(); i++) {
         a = a << 8 | bytes[i];
      }
      return a;
   }
}
