/*
 * Decompiled with CFR 0.152.
 */
package a3;

import a3.ByteString;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

class IO {
    private static BufferedInputStream inStream;
    private static BufferedOutputStream outStream;
    static int bytesRead;
    static final long MASK = 0xFFFFFFFFL;

    IO() {
    }

    static void openForRead(File f) throws IOException {
        inStream = new BufferedInputStream(new FileInputStream(f));
        bytesRead = 0;
    }

    static void openForWrite(File f) throws IOException {
        outStream = new BufferedOutputStream(new FileOutputStream(f));
    }

    static void closeForRead() throws IOException {
        inStream.close();
    }

    static void flush() throws IOException {
        outStream.flush();
    }

    static void closeForWrite() throws IOException {
        IO.flush();
        outStream.close();
    }

    static void cleanup() throws IOException {
        IO.closeForRead();
        IO.closeForWrite();
    }

    static int get() throws IOException {
        int b = -1;
        b = inStream.read();
        if (b != -1) {
            ++bytesRead;
        }
        return b;
    }

    static void put(int k) throws IOException {
        outStream.write(k);
    }

    static ByteString getByteString(int n) throws IOException {
        byte[] b = new byte[n];
        if (inStream.read(b) < n) {
            throw new IOException("Unexpected end of file");
        }
        bytesRead += n;
        return new ByteString(b);
    }

    static void putByteString(ByteString s) throws IOException {
        int i = 0;
        while (i < s.length()) {
            IO.put(s.byteAt(i));
            ++i;
        }
    }

    static int getInteger() throws IOException {
        int k = 0;
        int i = 0;
        while (i < 4) {
            int j = IO.get();
            if (j < 0) {
                throw new IOException("Unexpected end of file");
            }
            k = k << 8 | j;
            ++i;
        }
        return k;
    }

    static void putInteger(int n) throws IOException {
        IO.put(n >> 24 & 0xFF);
        IO.put(n >> 16 & 0xFF);
        IO.put(n >> 8 & 0xFF);
        IO.put(n & 0xFF);
    }

    static long getLong() throws IOException {
        return Long.rotateLeft((long)IO.getInteger() & 0xFFFFFFFFL, 32) | (long)IO.getInteger() & 0xFFFFFFFFL;
    }

    static void putLong(long n) throws IOException {
        IO.putInteger((int)(Long.rotateLeft(n, 32) & 0xFFFFFFFFL));
        IO.putInteger((int)(n & 0xFFFFFFFFL));
    }

    static int copy() throws IOException {
        int count = 0;
        int x = inStream.read();
        while (x != -1) {
            ++count;
            outStream.write(x);
            x = inStream.read();
        }
        return count;
    }

    static int copy(int m) throws IOException {
        int count = 0;
        while (count < m) {
            int x = inStream.read();
            if (x == -1) break;
            outStream.write(x);
            ++count;
        }
        return count;
    }
}

