/*
 * Decompiled with CFR 0.152.
 */
package a3;

import a3.Archive;
import a3.IO;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextArea;
import javax.swing.UIManager;

class GUI {
    static GUI gui;
    private final JFrame frame = new JFrame("211Zip");
    private final JTextArea fileList = new JTextArea();
    private final JLabel messageArea;
    private final MyHelpDialog helpDialog = new MyHelpDialog();
    private final AbstractAction newAction = new AbstractAction("New Archive..."){

        public void actionPerformed(ActionEvent e) {
            GUI.this.newArchive();
        }
    };
    private final AbstractAction openAction = new AbstractAction("Open Archive..."){

        public void actionPerformed(ActionEvent e) {
            GUI.this.openArchive();
        }
    };
    private final AbstractAction closeAction = new AbstractAction("Close Archive"){

        public void actionPerformed(ActionEvent e) {
            GUI.this.closeArchive();
        }
    };
    private final AbstractAction addAction = new AbstractAction("Add File..."){

        public void actionPerformed(ActionEvent e) {
            GUI.this.addFile();
        }
    };
    private final AbstractAction extractAction = new AbstractAction("Extract Files..."){

        public void actionPerformed(ActionEvent e) {
            GUI.this.extractFiles();
        }
    };

    GUI() {
        gui = this;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.frame.setDefaultCloseOperation(3);
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.add(new JMenuItem(this.newAction));
        fileMenu.add(new JMenuItem(this.openAction));
        fileMenu.add(new JMenuItem(this.closeAction));
        fileMenu.addSeparator();
        fileMenu.add(new JMenuItem(this.addAction));
        fileMenu.add(new JMenuItem(this.extractAction));
        fileMenu.addSeparator();
        JMenuItem byeMenuItem = new JMenuItem("Quit");
        byeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        fileMenu.add(byeMenuItem);
        menuBar.add(fileMenu);
        JMenu optionsMenu = new JMenu("Options");
        JMenu colorMenu = new JMenu("Color");
        ButtonGroup colorGroup = new ButtonGroup();
        ColorRadioButton c = new ColorRadioButton("White/Black", Color.white, Color.black);
        this.setColors(c.background, c.foreground);
        c.setSelected(true);
        colorGroup.add(c);
        colorGroup.add(new ColorRadioButton("Ithaca Sunset", new Color(204, 204, 204), new Color(0, 0, 0)));
        colorGroup.add(new ColorRadioButton("Spruce Forest", new Color(0, 45, 45), new Color(32, 196, 112)));
        colorGroup.add(new ColorRadioButton("Ocean Breeze", new Color(72, 200, 200), new Color(0, 20, 86)));
        colorGroup.add(new ColorRadioButton("681 Web Site", new Color(51, 51, 85), new Color(255, 255, 153)));
        colorGroup.add(new ColorRadioButton("682 Web Site", new Color(204, 204, 153), new Color(153, 0, 0)));
        colorGroup.add(new ColorRadioButton("Cornell", new Color(255, 255, 255), new Color(179, 27, 27)));
        colorGroup.add(new ColorRadioButton("Custom...", Color.lightGray, Color.lightGray));
        Enumeration<AbstractButton> e = colorGroup.getElements();
        while (e.hasMoreElements()) {
            colorMenu.add(e.nextElement());
        }
        optionsMenu.add(colorMenu);
        menuBar.add(optionsMenu);
        JMenu helpMenu = new JMenu("Help");
        JMenuItem item = new JMenuItem("Get help...");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUI.this.helpDialog.display();
            }
        });
        helpMenu.add(item);
        helpMenu.addSeparator();
        item = new JMenuItem("About...", 65);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String[] aboutMsg = new String[]{"211Zip Version 1.0", "Copyright \u00a9 2007 Cornell University"};
                JOptionPane.showMessageDialog(GUI.this.frame, aboutMsg, "About 211Zip", 1);
            }
        });
        helpMenu.add(item);
        menuBar.add(helpMenu);
        this.frame.setJMenuBar(menuBar);
        JPanel toolBar = new JPanel(new FlowLayout(0));
        toolBar.setBackground(Color.lightGray);
        toolBar.add(new JButton(this.newAction));
        toolBar.add(new JButton(this.openAction));
        toolBar.add(new JButton(this.closeAction));
        toolBar.add(new JButton(this.addAction));
        toolBar.add(new JButton(this.extractAction));
        this.frame.add((Component)toolBar, "North");
        this.fileList.setEditable(false);
        this.fileList.setFont(Font.decode("Courier"));
        this.fileList.setPreferredSize(new Dimension(0, 100));
        this.frame.add((Component)this.fileList, "Center");
        this.clearFiles();
        this.messageArea = new JLabel("", 2);
        this.messageArea.setBackground(Color.darkGray);
        this.frame.add((Component)this.messageArea, "South");
        this.clearMessage();
        this.setClosedState();
        this.frame.pack();
        this.frame.setLocation(200, 200);
        this.frame.setVisible(true);
    }

    private void setOpenState() {
        this.closeAction.setEnabled(true);
        this.addAction.setEnabled(true);
        this.extractAction.setEnabled(true);
    }

    private void setClosedState() {
        this.closeAction.setEnabled(false);
        this.addAction.setEnabled(false);
        this.extractAction.setEnabled(false);
    }

    private void setColors(Color b, Color f) {
        this.fileList.setBackground(b);
        this.fileList.setForeground(f);
    }

    private void setTitle(String s) {
        this.frame.setTitle(s);
    }

    private void listFiles(String s) {
        if (s.equals("")) {
            s = "No files";
        }
        this.fileList.setText(s);
    }

    private void clearFiles() {
        this.fileList.setText("");
    }

    private void message(String s) {
        this.messageArea.setText(" " + s);
    }

    private void clearMessage() {
        this.message("");
    }

    private void newArchive() {
        FileDialog openDialog = new FileDialog((Frame)this.frame, "New Archive", 1);
        openDialog.setDirectory(System.getProperty("user.dir"));
        openDialog.setVisible(true);
        if (openDialog.getFile() == null) {
            return;
        }
        Archive archive = new Archive(String.valueOf(openDialog.getDirectory()) + openDialog.getFile());
        archive.nFiles = 0;
        try {
            archive.writeHeader(archive);
            IO.closeForWrite();
        }
        catch (IOException ioe) {
            this.message("Cannot write archive: " + ioe.getMessage());
            return;
        }
        try {
            archive.read();
            Archive.archive = archive;
        }
        catch (IOException ioe) {
            this.message("Cannot read archive: " + ioe.getMessage());
        }
    }

    void initArchive(String name, String files) {
        this.listFiles(files);
        this.setTitle(name);
        this.clearMessage();
        this.setOpenState();
    }

    private void openArchive() {
        FileDialog openDialog = new FileDialog((Frame)this.frame, "Open Archive", 0);
        openDialog.setDirectory(System.getProperty("user.dir"));
        openDialog.setVisible(true);
        if (openDialog.getFile() == null) {
            return;
        }
        Archive archive = new Archive(String.valueOf(openDialog.getDirectory()) + openDialog.getFile());
        try {
            archive.open();
            Archive.archive = archive;
        }
        catch (Exception ioe) {
            this.message(ioe.getMessage());
        }
    }

    private void closeArchive() {
        try {
            Archive.archive.close();
        }
        catch (IOException ioe) {
            this.message(ioe.getMessage());
        }
        this.setClosedState();
        this.clearFiles();
        this.clearMessage();
    }

    private void addFile() {
        FileDialog openDialog = new FileDialog((Frame)GUI.gui.frame, "Select File to Add", 0);
        openDialog.setVisible(true);
        if (openDialog.getFile() == null) {
            return;
        }
        File file = new File(String.valueOf(openDialog.getDirectory()) + openDialog.getFile());
        try {
            Archive.archive.addFile(file);
        }
        catch (IOException ioe) {
            this.message(ioe.getMessage());
        }
    }

    private void extractFiles() {
        String dir = System.getProperty("java.io.tmpdir");
        this.message("Extracting files to " + dir + " ... ");
        try {
            Archive.archive.extract();
        }
        catch (IOException ioe) {
            this.message(ioe.getMessage());
            return;
        }
        this.message("Files extracted to " + dir);
    }

    private class ColorRadioButton
    extends JRadioButtonMenuItem
    implements ActionListener {
        Color background;
        Color foreground;

        ColorRadioButton(String s, Color b, Color f) {
            super(s);
            this.background = b;
            this.foreground = f;
            this.setActionCommand(s);
            this.addActionListener(this);
            if (!s.equals("Custom...")) {
                this.setIcon(this.createIcon(b, f));
            }
        }

        Icon createIcon(Color background, Color foreground) {
            BufferedImage image = new BufferedImage(12, 12, 1);
            Graphics graphics = ((Image)image).getGraphics();
            graphics.setColor(background);
            graphics.fillRect(0, 0, 12, 12);
            graphics.setColor(foreground);
            graphics.fillRect(5, 0, 2, 12);
            graphics.fillRect(0, 5, 12, 2);
            return new ImageIcon(image);
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("Custom...")) {
                Color bc = JColorChooser.showDialog(GUI.this.frame, "Choose Background Color", this.background);
                if (bc == null) {
                    return;
                }
                Color fc = JColorChooser.showDialog(GUI.this.frame, "Choose Foreground Color", this.foreground);
                if (fc == null) {
                    return;
                }
                this.background = bc;
                this.foreground = fc;
                this.setIcon(this.createIcon(bc, fc));
            }
            GUI.this.setColors(this.background, this.foreground);
        }
    }

    private class MyHelpDialog
    extends JDialog {
        BufferedImage logo;
        int width;
        int height;

        MyHelpDialog() {
            super((Frame)GUI.this.frame, "Help!");
            this.logo = null;
            this.width = 200;
            this.height = 200;
            try {
                this.logo = ImageIO.read(ClassLoader.getSystemResourceAsStream("a3/munch.gif"));
                this.width = this.logo.getWidth();
                this.height = this.logo.getHeight();
            }
            catch (Exception e) {
                this.add(new JLabel("Help!", 0));
            }
            this.setSize(this.width, this.height);
            this.setLocation(300, 300);
        }

        void display() {
            this.setVisible(true);
        }

        public void paint(Graphics graphics) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
            if (this.logo != null) {
                graphics.drawImage(this.logo, 0, 0, this.getBackground(), null);
            }
        }
    }
}

