/*
 * Decompiled with CFR 0.152.
 */
package a3;

import java.util.Arrays;
import java.util.NoSuchElementException;

class ByteString {
    private byte[] bytes;

    ByteString(byte[] b) {
        this.bytes = b;
    }

    ByteString(byte c) {
        this.bytes = new byte[1];
        this.bytes[0] = c;
    }

    ByteString(ByteString s) {
        this.bytes = new byte[s.length()];
        System.arraycopy(s.bytes, 0, this.bytes, 0, s.length());
    }

    ByteString(ByteString s, byte c) {
        this.bytes = new byte[s.length() + 1];
        System.arraycopy(s.bytes, 0, this.bytes, 0, s.length());
        this.bytes[s.length()] = c;
    }

    ByteString(String s) {
        this.bytes = s.getBytes();
    }

    int length() {
        return this.bytes.length;
    }

    byte byteAt(int index) {
        if (index < 0 || index >= this.length()) {
            throw new NoSuchElementException();
        }
        return this.bytes[index];
    }

    void setByteAt(int index, byte value) {
        if (index < 0 || index >= this.length()) {
            throw new NoSuchElementException();
        }
        this.bytes[index] = value;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ByteString)) {
            return false;
        }
        return Arrays.equals(this.bytes, ((ByteString)obj).bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public String toString() {
        return new String(this.bytes);
    }

    long toLong() {
        if (this.length() != 8) {
            throw new IllegalArgumentException();
        }
        long a = 0L;
        int i = 0;
        while (i < this.length()) {
            a = a << 8 | (long)this.bytes[i];
            ++i;
        }
        return a;
    }
}

