/*
 * Decompiled with CFR 0.152.
 */
package a3;

import java.util.BitSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BitVector
implements Iterable<Boolean> {
    private BitSet bitSet = new BitSet();
    private int size = 0;

    public void set(int index, boolean value) throws ArrayIndexOutOfBoundsException {
        if (index < 0 || index >= this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.bitSet.set(index, value);
    }

    public boolean get(int index) throws ArrayIndexOutOfBoundsException {
        if (index < 0 || index >= this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.bitSet.get(index);
    }

    public int size() {
        return this.size;
    }

    public void add(boolean value) {
        this.bitSet.set(this.size++, value);
    }

    @Override
    public Iterator<Boolean> iterator() {
        return new Iterator<Boolean>(){
            private int next = 0;

            @Override
            public boolean hasNext() {
                return this.next < BitVector.this.size();
            }

            @Override
            public Boolean next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return new Boolean(BitVector.this.bitSet.get(this.next++));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public BitVector clone() {
        BitVector bv = new BitVector();
        Iterator<Boolean> iter = this.iterator();
        while (iter.hasNext()) {
            bv.add(iter.next());
        }
        return bv;
    }
}

