/*
 * Decompiled with CFR 0.152.
 */
package a3;

import a3.BitVector;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BitStream {
    private ArrayList<Integer> stream;
    private RandomAccessFile raf;
    private String mode;
    private int bitlength = 0;

    public BitStream(File file, String mode) throws IOException {
        this.mode = new String(mode);
        this.stream = new ArrayList();
        if (mode.equals("w")) {
            this.raf = new RandomAccessFile(file, "rw");
            this.raf.writeInt(0);
        } else if (mode.equals("r")) {
            this.raf = new RandomAccessFile(file, "r");
            this.bitlength = this.raf.readInt();
            long fileLength = file.length();
            if ((long)((this.bitlength + 7) / 8) > fileLength - 4L) {
                throw new IllegalArgumentException("Corrupt input file");
            }
        } else {
            throw new IllegalArgumentException("Mode should be either \"r\" or \"w\"");
        }
    }

    public void writeBits(BitVector bits) throws IOException {
        this.bitlength += bits.size();
        Iterator<Boolean> iter = bits.iterator();
        while (iter.hasNext()) {
            this.stream.add(iter.next() != false ? 1 : 0);
        }
        while (this.stream.size() >= 8) {
            this.raf.writeByte(BitStream.bitsToInt(this.stream, 8));
        }
    }

    public void writeBits(int data, int n) throws IOException {
        this.bitlength += n;
        int i = n - 1;
        while (i >= 0) {
            this.stream.add(data >> i & 1);
            --i;
        }
        while (this.stream.size() >= 8) {
            this.raf.writeByte(BitStream.bitsToInt(this.stream, 8));
        }
    }

    private void flushBits() throws IOException {
        while (this.stream.size() % 8 != 0) {
            this.stream.add(0);
        }
        while (this.stream.size() >= 8) {
            this.raf.writeByte(BitStream.bitsToInt(this.stream, 8));
        }
    }

    public void close() throws IOException {
        if (this.mode.equals("w")) {
            this.flushBits();
            this.raf.seek(0L);
            this.raf.writeInt(this.bitlength);
        }
        this.raf.close();
    }

    public int readBits(int n) throws IOException {
        try {
            while (this.stream.size() < n) {
                byte b = this.raf.readByte();
                int i = 7;
                while (i >= 0) {
                    this.stream.add(b >> i & 1);
                    --i;
                }
            }
        }
        catch (EOFException e) {
            throw new IOException("Unexpected end of file");
        }
        int bits = BitStream.bitsToInt(this.stream, n);
        this.bitlength -= n;
        return bits;
    }

    private static int bitsToInt(List<Integer> bits, int n) {
        int ret = 0;
        int i = 0;
        while (i < n) {
            ret = ret << 1 | bits.get(0);
            bits.remove(0);
            ++i;
        }
        return ret;
    }

    public boolean hasMoreBits() {
        return this.bitlength > 0;
    }
}

