/*
 * Decompiled with CFR 0.152.
 */
package a3;

import a3.ByteString;
import a3.GUI;
import a3.IO;
import a3.Zip;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.Formatter;

class Archive
extends File {
    private static final int MAXNFILES = 256;
    private static final int MAXFILENAMELENGTH = 256;
    private static final long MAGIC = new ByteString("<211Zip>").toLong();
    int nFiles;
    private String[] fileName = new String[256];
    private int[] address = new int[256];
    private int[] uncompressedSize = new int[256];
    private long[] lastModified = new long[256];
    private int headerLength;
    static Archive archive = null;

    Archive(String fileName) {
        super(fileName);
    }

    void open() throws IOException {
        if (!this.exists()) {
            throw new FileNotFoundException("Archive does not exist");
        }
        if (!this.isFile() || this.length() == 0L) {
            throw new IllegalArgumentException("Not a valid archive");
        }
        if (!this.canRead()) {
            throw new IOException("Archive cannot be read");
        }
        if (!this.canWrite()) {
            throw new IOException("Archive cannot be written");
        }
        this.read();
    }

    void read() throws IOException {
        IO.openForRead(this);
        if (IO.getLong() != MAGIC) {
            throw new IllegalArgumentException("Not a valid archive");
        }
        this.nFiles = IO.getInteger();
        if (this.nFiles < 0 || this.nFiles > 256) {
            throw new IllegalArgumentException("Not a valid archive");
        }
        int i = 0;
        while (i < this.nFiles) {
            int m = IO.getInteger();
            if (m < 0 || m > 256) {
                throw new IllegalArgumentException("Not a valid archive");
            }
            this.fileName[i] = IO.getByteString(m).toString();
            this.address[i] = IO.getInteger();
            this.uncompressedSize[i] = IO.getInteger();
            this.lastModified[i] = IO.getLong();
            ++i;
        }
        this.headerLength = IO.bytesRead;
        int max = 0;
        i = 0;
        while (i < this.nFiles) {
            if (max < this.fileName[i].length()) {
                max = this.fileName[i].length();
            }
            ++i;
        }
        String formatString = "%-" + max + "s %d/%d %2.1f%% %s\n";
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb);
        i = 0;
        while (i < this.nFiles) {
            double compressionRatio = (double)Math.round(1000.0 - (double)this.compressedSize(i) * 1000.0 / (double)this.uncompressedSize[i]) / 10.0;
            formatter.format(formatString, this.fileName[i], this.compressedSize(i), this.uncompressedSize[i], compressionRatio, new Date(this.lastModified[i]).toString());
            ++i;
        }
        GUI.gui.initArchive(this.getAbsolutePath(), sb.toString());
    }

    void addFile(File f) throws IOException {
        if (!f.exists()) {
            throw new FileNotFoundException("File does not exist");
        }
        if (!f.isFile()) {
            throw new IllegalArgumentException("Not a valid file");
        }
        if (!f.canRead()) {
            throw new IOException("File cannot be read");
        }
        if (this.nFiles >= 256) {
            throw new IOException("Archive is full");
        }
        File tempArchive = File.createTempFile("zip", null);
        File fCompressed = File.createTempFile("com", null);
        this.fileName[this.nFiles] = f.getName();
        this.address[this.nFiles] = (int)this.length() - this.headerLength;
        this.uncompressedSize[this.nFiles] = (int)f.length();
        this.lastModified[this.nFiles++] = f.lastModified();
        Zip.codec.compress(f, fCompressed);
        this.writeHeader(tempArchive);
        IO.copy();
        IO.closeForRead();
        IO.openForRead(fCompressed);
        IO.copy();
        IO.cleanup();
        fCompressed.delete();
        IO.openForRead(tempArchive);
        IO.openForWrite(this);
        IO.copy();
        IO.cleanup();
        tempArchive.delete();
        this.read();
    }

    void extract() throws IOException {
        File dir = new File(System.getProperty("java.io.tmpdir"));
        String dirName = String.valueOf(dir.getAbsolutePath()) + File.separator;
        if (!dir.exists()) {
            throw new FileNotFoundException("Directory " + dirName + " does not exist");
        }
        if (dir.isFile()) {
            throw new IllegalArgumentException(String.valueOf(dirName) + " is not a directory");
        }
        if (!dir.canRead()) {
            throw new IOException("Cannot read " + dirName);
        }
        if (!dir.canWrite()) {
            throw new IOException("Cannot write to " + dirName);
        }
        File[] fCompressed = new File[this.nFiles];
        int i = 0;
        while (i < this.nFiles) {
            fCompressed[i] = File.createTempFile(String.valueOf(this.fileName[i]) + "-com", null);
            IO.openForWrite(fCompressed[i]);
            IO.copy(this.compressedSize(i));
            IO.closeForWrite();
            ++i;
        }
        IO.closeForRead();
        i = 0;
        while (i < this.nFiles) {
            File f = new File(String.valueOf(dirName) + this.fileName[i]);
            Zip.codec.decompress(fCompressed[i], f);
            fCompressed[i].delete();
            f.setLastModified(this.lastModified[i]);
            ++i;
        }
        this.read();
    }

    private int compressedSize(int i) {
        return (i < this.nFiles - 1 ? this.address[i + 1] : (int)this.length() - this.headerLength) - this.address[i];
    }

    void writeHeader(File archive) throws IOException {
        IO.openForWrite(archive);
        IO.putLong(MAGIC);
        IO.putInteger(this.nFiles);
        int i = 0;
        while (i < this.nFiles) {
            IO.putInteger(this.fileName[i].length());
            IO.putByteString(new ByteString(this.fileName[i]));
            IO.putInteger(this.address[i]);
            IO.putInteger(this.uncompressedSize[i]);
            IO.putLong(this.lastModified[i]);
            ++i;
        }
        IO.flush();
    }

    void close() throws IOException {
        archive = null;
        IO.closeForRead();
    }
}

