/**
 This type is used to represent the type of a token,
 including punctuation, parts of speech and special
 values
 @see Token
*/
enum TokenCategory {
   Terminator, /** End of sentence -- e.g. a period or an exclamation mark */
   Quote,
   Determiner,
   Noun,
   Adjective,
   Verb,
   Preposition,
   Adverb,
   Blank,    /** Denotes a blank that the program should fill in */
   Unknown,  /** Marks a word not in the dictionary */
   Error,    /** Used when there was an error reading the input */
   EndOfFile /** Marks the end of file */
}
