import java.io.*;

/** This class is the main application for filling in stories from files. */
public class StoryCompleter {

   public static void main(String[] args) {
      if (args.length != 1) {
         System.err.println("Usage: java StoryCompleter filename");
         return;
      }

      //Setup the dictionary..
      Dictionary dictionary;

      try {
         dictionary = new Dictionary();
      } catch (DictionaryException de) {
         System.err.println(de.getMessage());
         return;
      }

      //Setup the file
      BufferedReader input;

      try {
         input = new BufferedReader(new FileReader(args[0]));
      } catch (FileNotFoundException fe) {
         System.err.println("Unable to open file " + args[0]);
         return;
      }

      //Now we can make a tokenizer and a parser..
      Tokenizer tokenizer = new Tokenizer(dictionary, input);
      Parser    parser    = new Parser   (dictionary, tokenizer);

      //Keep parsing sentences until EOF, and output the parse results..
      while (tokenizer.lookahead() != TokenCategory.EndOfFile) {
         try {
            String result = parser.parseSentence();
            System.out.println(result);
         } catch (ParserException pe) {
            System.err.println("Parse error:" + pe.getMessage());
            return;
         }
      }
   }
}

