/**
 This type of exception is thrown if there is an error parsing the input
 sentence. The error message contains the description of the problem
 @see Parser
*/
class ParserException extends Exception {
	public ParserException(String message) {
		super(message);
	}
}

class Parser {
	private Tokenizer  tokenizer;
	private Dictionary dictionary;
   private StringBuffer output;
	
	public Parser(Dictionary dictionary, Tokenizer tokenizer) {
		this.tokenizer  = tokenizer;
		this.dictionary = dictionary;
	}
		
	/** Main entry point of the parser. Parses a sentence from the input,
	 and fills in the blanks if possible. If there is an 
	 error, this will throw the ParserException. If successful,
	 it will return the completed "sentence"
	*/
	public String parseSentence() throws ParserException {
		output = new StringBuffer(); //clear it from previous calls..
		parseS();
		return output.toString();
	}
   
   private void parseS() throws ParserException {
      throw new ParserException("Parser not implemented");
   }
}

