import java.io.*;

/**
 This is a test application for testing the parser/completer in an
 interactive fashion rather than files.
*/
class CompleterTester {
	public static void main(String[] args) {
		BufferedReader input = new BufferedReader(
					new InputStreamReader(System.in));
		
		Dictionary d;
		 
		try {
			d = new Dictionary();
		} catch (DictionaryException de) {
			System.err.println(de.getMessage());
			return;
		}
		
		System.out.println("Enter a sentence to complete it,");
		System.out.println("type an empty line to quit");
		
		boolean quit = false;
		do {
			try {
				String line = input.readLine();
				if (line.length() != 0) {
					try {
						Parser parser = new Parser(d,
							new Tokenizer(d, new StringReader(line)));
						System.out.println(parser.parseSentence());
					} catch (ParserException pe) {
						System.err.println("Parse error:" + pe.getMessage());
					}
				} else {
					quit = true;
				}
			} catch (IOException e) {
				System.err.println("Error reading input:" + e.getMessage() +
					" --- aborting");
				quit = true;
			}
		}
		while (!quit);
	}
}
