/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;
import java.util.Queue;

class Tokenizer {
    private Dictionary dictionary;
    private Reader input;
    private IOException errorObject;
    private Queue<Token> tokens = new LinkedList<Token>();
    private char[] readBuffer = new char[1024];
    private StringBuffer currentString = new StringBuffer();
    private boolean inBlank = false;

    public Tokenizer(Dictionary dictionary, Reader input) {
        this.dictionary = dictionary;
        this.input = input;
    }

    public Token nextToken() {
        if (this.errorObject != null) {
            return new Token(TokenCategory.Error, this.errorObject.getMessage());
        }
        this.bufferIfNeeded();
        if (this.tokens.isEmpty()) {
            return new Token(TokenCategory.EndOfFile, "");
        }
        return this.tokens.remove();
    }

    public TokenCategory lookahead() {
        if (this.errorObject != null) {
            return TokenCategory.Error;
        }
        this.bufferIfNeeded();
        if (this.tokens.isEmpty()) {
            return TokenCategory.EndOfFile;
        }
        return this.tokens.peek().category;
    }

    /*
     * Unable to fully structure code
     */
    private void bufferIfNeeded() {
        if (this.tokens.isEmpty()) ** GOTO lbl32
        return;
lbl-1000:
        // 1 sources

        {
            try {
                read = this.input.read(this.readBuffer, 0, this.readBuffer.length);
            }
            catch (IOException ie) {
                this.errorObject = ie;
                return;
            }
            if (read == -1) {
                this.completeToken();
                return;
            }
            pos = 0;
            while (pos < read) {
                letter = this.readBuffer[pos];
                if (!this.inBlank) ** GOTO lbl21
                if (letter == '_') {
                    this.currentString.append(letter);
                } else {
                    this.completeToken();
lbl21:
                    // 2 sources

                    if (!Character.isLetter(letter) && letter != '\'') {
                        this.completeToken();
                    }
                    if (!Character.isWhitespace(letter)) {
                        if (letter == '_') {
                            this.inBlank = true;
                        }
                        this.currentString.append(letter);
                        if (!Character.isLetter(letter) && letter != '\'' && letter != '_') {
                            this.completeToken();
                        }
                    }
                }
                ++pos;
            }
lbl32:
            // 2 sources

            ** while (this.tokens.isEmpty())
        }
lbl33:
        // 1 sources

    }

    private void completeToken() {
        if (this.currentString.length() != 0) {
            String value = this.currentString.toString();
            this.tokens.add(new Token(this.dictionary.classifyWord(value), value));
            this.currentString = new StringBuffer();
            this.inBlank = false;
        }
    }
}

