/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;

public class StoryCompleter {
    public static void main(String[] args) {
        BufferedReader input;
        Dictionary dictionary;
        if (args.length != 1) {
            System.err.println("Usage: java StoryCompleter filename");
            return;
        }
        try {
            dictionary = new Dictionary();
        }
        catch (DictionaryException de) {
            System.err.println(de.getMessage());
            return;
        }
        try {
            input = new BufferedReader(new FileReader(args[0]));
        }
        catch (FileNotFoundException fe) {
            System.err.println("Unable to open file " + args[0]);
            return;
        }
        Tokenizer tokenizer = new Tokenizer(dictionary, input);
        Parser parser = new Parser(dictionary, tokenizer);
        while (tokenizer.lookahead() != TokenCategory.EndOfFile) {
            try {
                String result = parser.parseSentence();
                System.out.println(result);
            }
            catch (ParserException pe) {
                System.err.println("Parse error:" + pe.getMessage());
                return;
            }
        }
    }
}

