/*
 * Decompiled with CFR 0.152.
 */
class Parser {
    private Tokenizer tokenizer;
    private Dictionary dictionary;
    private StringBuffer output;

    public Parser(Dictionary dictionary, Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
        this.dictionary = dictionary;
    }

    public String parseSentence() throws ParserException {
        this.output = new StringBuffer();
        this.parseS();
        return this.output.toString();
    }

    private void parseS() throws ParserException {
        if (this.tokenizer.lookahead() == TokenCategory.Quote) {
            this.parseQuoteSentence();
        } else {
            this.parseDeclarativeSentence();
        }
        this.consume(TokenCategory.Terminator);
    }

    private void consume(TokenCategory expected) throws ParserException {
        Token token = this.tokenizer.nextToken();
        if (token.category == expected) {
            this.addWord(token.value);
        } else if (token.category == TokenCategory.Blank) {
            this.addWord(this.dictionary.generateWord(expected));
        } else if (token.category == TokenCategory.Unknown) {
            this.error("Word " + token.value + " not known");
        } else if (token.category == TokenCategory.Error) {
            this.error("Input error: " + token.value);
        } else {
            this.error("Expected a " + expected.toString() + " but got " + token.category.toString() + " (" + token.value + ")");
        }
    }

    private void addWord(String word) {
        if (this.output.length() != 0) {
            this.output.append(' ');
        }
        this.output.append(word);
    }

    private void parseDeclarativeSentence() throws ParserException {
        this.parseNP();
        this.parseVP();
    }

    private void parseQuoteSentence() throws ParserException {
        this.consume(TokenCategory.Quote);
        this.parseDeclarativeSentence();
        this.consume(TokenCategory.Quote);
        this.consume(TokenCategory.Verb);
        this.parseNP();
    }

    private void parseNP() throws ParserException {
        this.consume(TokenCategory.Determiner);
        this.consume(TokenCategory.Adjective);
        this.consume(TokenCategory.Noun);
        this.parseMaybePP();
    }

    private void parseMaybePP() throws ParserException {
        this.ensureNotBlank();
        if (this.tokenizer.lookahead() == TokenCategory.Preposition) {
            this.consume(TokenCategory.Preposition);
            this.parseNP();
        }
    }

    private void parseVP() throws ParserException {
        this.consume(TokenCategory.Adverb);
        this.consume(TokenCategory.Verb);
        this.parseMayBeNP();
    }

    private void parseMayBeNP() throws ParserException {
        this.ensureNotBlank();
        if (this.tokenizer.lookahead() == TokenCategory.Determiner) {
            this.parseNP();
        }
    }

    private void ensureNotBlank() throws ParserException {
        if (this.tokenizer.lookahead() == TokenCategory.Blank) {
            this.error("Unable to predict sentence structure due to a blank, got as far as:" + this.output);
        }
    }

    private void error(String message) throws ParserException {
        throw new ParserException(message);
    }
}

