/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

class Dictionary {
    private Random prng = new Random();
    private Map<TokenCategory, ArrayList<String>> words = new HashMap<TokenCategory, ArrayList<String>>();
    private Map<String, TokenCategory> wordCategories = new HashMap<String, TokenCategory>();

    Dictionary() throws DictionaryException {
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader("dictionary.txt"));
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
                int pos = line.indexOf(32);
                if (pos == -1 || pos == line.length() - 1) {
                    throw new DictionaryException("Invalid line " + line + " in dictionary");
                }
                String word = line.substring(0, pos).trim();
                String cat = line.substring(pos + 1).trim();
                cat = String.valueOf(cat.substring(0, 1).toUpperCase()) + cat.substring(1).toLowerCase();
                TokenCategory tcat = null;
                try {
                    tcat = TokenCategory.valueOf(cat);
                }
                catch (IllegalArgumentException e) {
                    throw new DictionaryException("Unknown lexical category " + cat + " for word " + word);
                }
                if (tcat == TokenCategory.Unknown || tcat == TokenCategory.EndOfFile) {
                    throw new DictionaryException("Invalid attempt to customize lexical category " + (Object)((Object)tcat));
                }
                this.addToDictionary(word, tcat);
            }
        }
        catch (IOException e) {
            throw new DictionaryException("Error reading in dictionary: " + e.getMessage());
        }
        EnumSet<TokenCategory> builtins = EnumSet.of(TokenCategory.Blank, TokenCategory.Unknown, TokenCategory.Error, TokenCategory.EndOfFile);
        for (TokenCategory cat : EnumSet.complementOf(builtins)) {
            if (this.words.containsKey((Object)cat)) continue;
            throw new DictionaryException("The dictionary does not contain words of category:" + (Object)((Object)cat));
        }
    }

    private void addToDictionary(String word, TokenCategory tcat) {
        String wordKey = word.toLowerCase();
        ArrayList<String> wordsOfCat = this.words.get((Object)tcat);
        if (wordsOfCat == null) {
            wordsOfCat = new ArrayList();
            this.words.put(tcat, wordsOfCat);
        }
        wordsOfCat.add(word);
        this.wordCategories.put(wordKey, tcat);
    }

    public String generateWord(TokenCategory category) {
        ArrayList<String> wordsOfCat = this.words.get((Object)category);
        return wordsOfCat.get(this.prng.nextInt(wordsOfCat.size()));
    }

    public TokenCategory classifyWord(String word) {
        word = word.toLowerCase();
        boolean isBlank = true;
        int c = 0;
        while (c < word.length()) {
            if (word.charAt(c) != '_') {
                isBlank = false;
                break;
            }
            ++c;
        }
        if (isBlank) {
            return TokenCategory.Blank;
        }
        if (this.wordCategories.containsKey(word)) {
            return this.wordCategories.get(word);
        }
        return TokenCategory.Unknown;
    }
}

