/*
 * Decompiled with CFR 0.152.
 */
package a2;

import a2.Command;
import a2.Operation;
import java.util.ArrayList;
import java.util.Random;

public class FileSystemTest {
    private final Random rand = new Random();
    private final char[] letters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private final ArrayList<String> files = new ArrayList();

    private String getName() {
        int length = this.rand.nextInt(5) + 5;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < length) {
            sb.append(this.letters[this.rand.nextInt(this.letters.length)]);
            ++i;
        }
        String s = sb.toString();
        if (!this.files.contains(s)) {
            return s;
        }
        return this.getName();
    }

    private Operation createFile() {
        String s = this.getName();
        this.files.add(0, s);
        return new Operation(Command.CREATE, s);
    }

    private int getRandomElement() {
        double ALPHA = 0.1;
        double BETA = 0.95;
        double p = 0.1;
        int i = 0;
        while (i < this.files.size()) {
            if (this.rand.nextDouble() <= p) break;
            p *= 0.95;
            ++i;
        }
        if (i >= this.files.size()) {
            i = this.files.size() - 1;
        }
        return i;
    }

    private Operation destroyFile() {
        if (this.files.size() == 0) {
            throw new Error("No files to destroy");
        }
        int i = this.getRandomElement();
        String s = this.files.get(i);
        this.files.remove(i);
        return new Operation(Command.DELETE, s);
    }

    private Operation accessFile() {
        if (this.files.size() == 0) {
            throw new Error("No files to access");
        }
        int i = this.getRandomElement();
        String s = this.files.get(i);
        this.files.remove(i);
        this.files.add(0, s);
        return new Operation(Command.ACCESS, s);
    }

    public Operation nextOperation() {
        double LAMBDA = 0.01;
        if (this.rand.nextDouble() <= Math.pow(2.0, (double)(-this.files.size()) * 0.01)) {
            return this.createFile();
        }
        if (this.rand.nextInt(10) == 0) {
            return this.destroyFile();
        }
        return this.accessFile();
    }
}

