/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;

public class Patient {
    private static final char[] CONSONANTS = "bcdfghjklmnprstvz".toCharArray();
    private static final char[] VOWELS = new char[]{'a', 'e', 'i', 'o', 'u'};
    private static final int INITIAL_HEALTH = 50;
    static final int CURED = 100;
    static final int DEAD = 0;
    static final int TREATED_GAIN = 10;
    static final int UNTREATED_LOSS = 1;
    private Random rand = new Random();
    final String name = this.getName();
    int health = 50;
    int age = this.rand.nextInt(70) + 10;

    Patient() {
    }

    boolean cured() {
        return this.health >= 100;
    }

    boolean died() {
        return this.health <= 0;
    }

    boolean treatable() {
        return !this.cured() && !this.died();
    }

    void treat() {
        if (this.treatable()) {
            this.health = Math.min(this.health + 10, 100);
        }
    }

    void untreated() {
        if (this.treatable()) {
            this.health = Math.max(this.health - 1, 0);
        }
    }

    private char consonant() {
        return CONSONANTS[this.rand.nextInt(CONSONANTS.length)];
    }

    private char vowel() {
        return VOWELS[this.rand.nextInt(VOWELS.length)];
    }

    private String getName() {
        StringBuilder s = new StringBuilder();
        s.append(Character.toUpperCase(this.consonant()));
        s.append(this.vowel());
        if (this.rand.nextInt(2) == 0) {
            s.append(this.consonant());
        }
        s.append(this.consonant());
        s.append(this.vowel());
        if (this.rand.nextInt(2) == 0) {
            s.append(this.consonant());
        }
        if (this.rand.nextInt(2) == 0) {
            s.append(this.consonant());
            s.append(this.vowel());
        }
        s.append(' ');
        s.append(Character.toUpperCase(this.consonant()));
        s.append(this.vowel());
        if (this.rand.nextInt(2) == 0) {
            s.append(this.consonant());
        }
        s.append(this.consonant());
        s.append(this.vowel());
        if (this.rand.nextInt(2) == 0) {
            s.append(this.consonant());
        }
        if (this.rand.nextInt(2) == 0) {
            s.append(this.consonant());
            s.append(this.vowel());
        }
        return s.toString();
    }
}

