/*
 * Decompiled with CFR 0.152.
 */
import java.util.Scanner;

public class Hospital {
    Room firstRoom = Room.createRooms();
    Doctor doctor = new Doctor(this.firstRoom);

    public static void main(String[] args) {
        new Hospital().play();
    }

    Hospital() {
    }

    void play() {
        System.out.println();
        System.out.println("*******************************************");
        System.out.println("* Welcome to Krzmrgystan General Hospital *");
        System.out.println("*******************************************");
        System.out.println();
        System.out.println("Type 'h' for instructions");
        Scanner scanner = new Scanner(System.in);
        while (!this.done()) {
            this.displayStatus();
            System.out.print("n=next, p=prev, t=treat, h=help, q=quit? ");
            this.processCommand(scanner.nextLine());
        }
        this.displayStatus();
        System.out.format("Medicine remaining: %d\n", this.doctor.medicine);
        System.out.format("Patients cured: %d\n", this.cured());
    }

    private void processCommand(String cmd) {
        int i = 0;
        while (i < cmd.length() && !this.done()) {
            char ch = cmd.charAt(i);
            switch (ch) {
                case 't': {
                    this.treat();
                    break;
                }
                case 'p': {
                    this.move('p');
                    break;
                }
                case 'n': {
                    this.move('n');
                    break;
                }
                case 'h': {
                    this.displayHelp();
                    break;
                }
                case 'q': {
                    this.quit();
                }
                default: {
                    System.out.format("Unknown command %c\n", Character.valueOf(ch));
                }
            }
            ++i;
        }
    }

    private void quit() {
        System.exit(0);
    }

    private void treat() {
        if (!this.doctor.medicineLeft()) {
            return;
        }
        this.doctor.location.patient.treat();
        this.doctor.useMedicine();
        Room room = this.doctor.location.next;
        while (room != this.doctor.location) {
            room.patient.untreated();
            room = room.next;
        }
    }

    private void move(char ch) {
        Room room = this.doctor.location = ch == 'n' ? this.doctor.location.next : this.doctor.location.prev;
        do {
            room.patient.untreated();
        } while ((room = room.next) != this.doctor.location);
    }

    private int cured() {
        Room room = this.doctor.location;
        int n = 0;
        do {
            if (!room.patient.cured()) continue;
            ++n;
        } while ((room = room.next) != this.doctor.location);
        return n;
    }

    private boolean done() {
        if (!this.doctor.medicineLeft()) {
            return true;
        }
        Room room = this.doctor.location;
        do {
            if (!room.patient.treatable()) continue;
            return false;
        } while ((room = room.next) != this.doctor.location);
        return true;
    }

    private void displayStatus() {
        System.out.format("\n%-4s %-17s %-3s %s\n", "Room", "Patient", "Age", "Health");
        Room room = this.firstRoom;
        do {
            System.out.format("%3d  %-17s %2d  %d", room.roomNumber, room.patient.name, room.patient.age, room.patient.health);
            if (room.patient.cured()) {
                System.out.print(" recovered!");
            }
            if (room.patient.died()) {
                System.out.print(" died!");
            }
            System.out.println();
        } while ((room = room.next) != this.firstRoom);
        System.out.format("\nThe doctor is in room %d with %d units of medicine\n", this.doctor.location.roomNumber, this.doctor.medicine);
    }

    private void displayHelp() {
        System.out.println();
        System.out.println("-------------------------------------------------------------");
        System.out.println("Krzmrgystan General Hospital Help");
        System.out.format("There are %d rooms arranged in a ring, each with 1 patient.\n", 10);
        System.out.println("Enter a command at the prompt.  The commands are:");
        System.out.println("  n  move to the next (higher-numbered) room");
        System.out.println("  p  move to the previous (lower-numbered) room");
        System.out.println("  t  treat the patient in this room");
        System.out.println("  h  display this help screen");
        System.out.println("  q  quit");
        System.out.println("You can enter a sequence of commands on the same line,");
        System.out.println("  like this: ttttn");
        System.out.println("Treating a patient uses one unit of medicine, after which the");
        System.out.format("  treated patient's health improves by %d.\n", 10);
        System.out.println("Treating a patient or moving takes one unit of time, during");
        System.out.format("  which all untreated patients' health deteriorates by %d.\n", 1);
        System.out.format("A patient is cured when his/her health reaches %d.\n", 100);
        System.out.format("A patient dies when his/her health reaches %d.\n", 0);
        System.out.println("How many patients can you save?");
        System.out.println("-------------------------------------------------------------");
    }
}

