import java.util.*;

public class TestCircle {

    public static void main(String[] args) {
	
	// Create list with sentinel as first node:
	Circle c = new Circle(-1); // create Circle with sentinel
	Node s = c.sentinel;       // set reference s to sentinel node
	
	// Add nodes to list:
	Node n0 = new Node(0); Node n1 = new Node(1); 			
	Node n2 = new Node(2); Node n3 = new Node(3);
	s.next = n0; n0.next = n1; n1.next = n2; n2.next = n3; n3.next = s;
	 
	// Enumerate Circle nodes, but skip sentinel:
	Iterator i = c.new CircleIterator();
	while( i.hasNext() ) System.out.print( i.next() ); // outputs 0123
    }
    
} // Class TestCircle

class Node {
    public Node next;
    public Object data;
    public Node(int d) { data = new Integer(d); }
    public String toString() { return ""+data; }
} // Class Node

class Circle {
    public Node sentinel; // ref to sentinel node in circularly linked list

    // Create Circle with sentinel node that contains dummy value:
    Circle(int d) { 			
	sentinel = new Node(d);    // create sentinel with arbitrary (dummy) value
	sentinel.next = sentinel;  // create default circular list
    } 
    
    // CircleIterator enumerates the elements of the list, which sentinel points to.
    // Iteration starts at sentinel's next and continues to sentinel's previous node:
    public class CircleIterator implements Iterator {
	private Node cursor; // finger into list

	// Create a CircleIterator and set cursor to sentinel's next:
	public CircleIterator( ) {
	    cursor=sentinel.next;
	}

	public boolean hasNext( ) {
	    return cursor!=sentinel;
	}

	public Object next( ) {
	    Object result = cursor.data;
	    cursor=cursor.next;
	    return result;
	}
	
	// Do not implement Iterator's remove method:
	public void remove( ) { }
	
    } // Class CircleIterator
} // Class Circle
