// Example: the listener is an inner class

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class ListenerExample2 extends JFrame { 
    
    private int count;
    private JButton b = new JButton("Push Me!");
    private JLabel label = new JLabel(generateLabel());
    
    class Helper implements ActionListener {
        public void actionPerformed (ActionEvent e) {
            count++;
            label.setText(generateLabel());
        }
    }
    
    public static void main (String[] args) {
        JFrame f = new ListenerExample2();
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        f.setSize(200,100);
        f.setVisible(true);
    }
    
    public ListenerExample2() {
        setLayout(new FlowLayout(FlowLayout.LEFT) );
        add(b);
        add(label);
        b.addActionListener(new Helper());
    }
    
    private String generateLabel() {
        return "Count: "+count;
    }  
}

    

