// Example: uses an adapter to count number of mouse entries

import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;

public class AdapterExample extends JFrame { 
    
    private int count;
    private JButton b = new JButton("Mouse Me!");
    private JLabel label = new JLabel(generateLabel());
    
    class Helper extends MouseInputAdapter {
        public void mouseEntered (MouseEvent e) {
            count++;
            label.setText(generateLabel());
        }
    }
    
    public static void main (String[] args) {
        JFrame f = new AdapterExample();
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        f.setSize(200,100);
        f.setVisible(true);
    }
    
    public AdapterExample() {
        setLayout(new FlowLayout(FlowLayout.LEFT) );
        add(b);
        add(label);
        b.addMouseListener(new Helper());
    }
    
    private String generateLabel() {
        return "Count: "+count;
    }  
}

    

