public class TestBST {
    public static void main(String[] args) {

        BinaryTree bt = new BinaryTree();
        BinaryNode b5 = new BinaryNode(new Integer(5));
        bt.root=b5;
        BinaryNode b1 = new BinaryNode(new Integer(1));
        BinaryNode b2 = new BinaryNode(new Integer(2));
        BinaryNode b3 = new BinaryNode(new Integer(3));
        BinaryNode b4 = new BinaryNode(new Integer(4));
        BinaryNode b6 = new BinaryNode(new Integer(6));
        BinaryNode b7 = new BinaryNode(new Integer(7));
        BinaryNode b8 = new BinaryNode(new Integer(8));
        BinaryNode b9 = new BinaryNode(new Integer(9));

        b5.left=b4;
        b5.right=b6;
        b4.left=b2;
	b2.left=b1;
	b2.right=b3;
        b5.right=b7;
	b7.left=b6;
	b7.right=b9;
	b9.left=b8;
	/*
	b5.left=b3;
	b5.right=b6;
	b3.right=b9;
	*/
	System.out.println(bt.toTree());
	System.out.println(bt.isBST());

    }
}

class BinaryTree {
    public BinaryNode root;
    public BinaryTree( ) { root = null; }
    public BinaryTree(Object data) { this.root = new BinaryNode(data); }
    public String toTree() { return root.toTree(); }

    public boolean isBST() {
	return isBST(root);
    }

    private boolean isBST(BinaryNode n) {
        if (n == null) return true;
	if ( isBST(n.left) && isBST(n.right) &&
	     ((n.left == null)  || ((Comparable) (n.data)).compareTo(findRightMost(n.left)) >= 0) &&
	     ((n.right == null) || ((Comparable) (n.data)).compareTo(findLeftMost(n.right)) <= 0))
	    return true;
        return false;
    }

    private Object findRightMost(BinaryNode n) {
        if (n==null) return null;
        if (n.right==null) return n.data;
        else return findRightMost(n.right);
    }

    private Object findLeftMost(BinaryNode n) {
        if (n==null) return null;
        if (n.left==null) return n.data;
        else return findLeftMost(n.left);
    }

}

class BinaryNode {
    public BinaryNode left;
    public BinaryNode right;
    public Object     data;
    public BinaryNode(Object data) { this.data=data; }
    public String toTree() { return toTree("|   ","|___"); } 
    public String toTree(String blank,String spacing) {
	String s = "" + data + "\n";
	if (left == null) s += spacing + "\n";
	else s += spacing + left.toTree(blank, blank+spacing);
	if (right == null) s += spacing + "\n";
	else s += spacing + right.toTree(blank, blank+spacing);
	return s;
    }
}
