public class Problem6 {

    private static CS211InInterface fin = new CS211In();   

    public static void main(String[] args) {
	System.out.print("Enter a PSE: ");
	System.out.println(new ParseTree(fin));
	fin.close();
    }
}

class ParseTree implements INode {
    private INode root; 
    public ParseTree(CS211InInterface fin) {
	root = makeTree(fin);
    }

    private INode makeTree(CS211InInterface fin) {
	
	switch( fin.peekAtKind() ) {
	    // E -> int
  	    case CS211In.INTEGER:
		int i = fin.getInt(); 
		return new IntNode(i);
		
	    // E -> (E1 + E2)
	       case CS211In.OPERATOR:
		   fin.check('(');
		   INode leftExpr = makeTree(fin);
		   fin.check('+');
		   INode rightExpr = makeTree(fin);
		   fin.check(')');
		   return new AddNode(leftExpr,rightExpr);
		    
	} // end switch

	return null;

    } // Method makeTree

    // Return tree-like output of tree:
    public String toString() { 
	if(root==null) 
	    return "";
	return root.toString(); 
    }

} 

class AddNode implements INode {

    private INode leftExpr;
    private INode rightExpr;

    // Build a new Binary Node with op as it's root:
    public AddNode (INode leftExpr, INode rightExpr) {
	this.leftExpr=leftExpr;
	this.rightExpr=rightExpr;
    }

    public String toString() {
	return leftExpr + "+" + rightExpr;
    }
    
}

class IntNode implements INode {

    private int value;

    public IntNode (int val) {
	this.value = val;
    }

    public String toString() {
	return ""+value;
    }

} // Class IntNode

interface INode {
    public String toString();
}
