import java.awt.*;
import javax.swing.*;
import java.awt.event.*;

/** An instance of this class models the outside temperature. An instance
 has a window (a Frame) that displays the outside temperature. It can be
 changed by typing the new temperature into textField and pressing a
 button. An instance has its own thread of execution. Its method run
 is in superclass ClockedFrame. */
public class OutsideTemperature extends ClockedFrame implements ActionListener {
    
    // Components for the frame
    JLabel label= new JLabel("Outside temperature:   ");
    JTextField textField= new JTextField();
    JButton button = new JButton("Read temperature");
    
    private double temperature; // The outside temperature
    
    /** Constructor: an outside-temperature control, which uses clock c,
     with initial temperature t */
    public OutsideTemperature(SystemClock c, int t) {
        super(c, "Outside");
        temperature= t;
        Container cp= getContentPane();
        cp.add("North", label);
        cp.add("Center", textField);
        textField.setText("" + temperature);
        cp.add("South", button);
        button.addActionListener(this);
        //resize(600, 200);
        pack();
        move(135, 100);
        show();
    }
    
    /** = the current outside temperature. */
    public synchronized double readValue() {
        notifyAll();
        return(temperature);
    }
    
    /** Handle press of "Read temperature" */
    public void actionPerformed(ActionEvent e) {
        // Here, method getText obtains
        // the sequence of characters in component textField on the Frame;
        // trim removes whitespace at either end of the String, and parseInt
        // converts it to an integer.
        String t= textField.getText().trim();
        temperature= Integer.parseInt(t);
    }
    
}



