import java.awt.*;
import javax.swing.*;
import java.awt.event.*;

/** An instance of this class models the inside temperature in a house. The
 inside temperature is changed by calling method changeTemp. An instance
 of this class has a window (a Frame) that displays the inside temperature.
 An instance has its own thread of execution --method run is in
 superclass ClockedFrame. */
public class InsideTemperature extends ClockedFrame {
    
    // Components that go in this Frame
    JLabel label= new JLabel("Inside temperature:   ");
    JLabel tempLabel= new JLabel("72");
    
    private double temperature; // Current inside temperature
    
    /** Constructor: inside-temperature control; the clock is c
     and the initial desired inside temperature is t */
    public InsideTemperature(SystemClock c, int t) {
        super(c, "Inside");
        temperature = t;
        tempLabel.setText("" + temperature);
        Container cp= getContentPane();
        cp.add("North", label);
        cp.add("Center", tempLabel);
        //resize(600, 200);
        pack();
        move(622, 100);
        show();
    }
    
    /** = the current inside temperature */
    public synchronized double readValue() {
        notifyAll();
        return(temperature);
    }
    
    /** Set the inside temperature to t */
    public synchronized void setValue(double t) {
        temperature= t;
        notifyAll();
        tempLabel.setText(ThermoApplet.decform.format(temperature));
    }
}



