import java.awt.*;
import javax.swing.*;
import java.awt.event.*;

/** An instance of this class models a furnace, which can be turned
    on or off. The instance has a window (a Frame) that contains the
    status of the furnace as well as an output-on-or-off toggle
    button. A Furnace has its own thread of execution. Its method
    run appears in superclass ClockedFrame */
public class Furnace extends ClockedFrame implements ActionListener {
    
    // The components that go on the Frame
    private static final String [] buttons= {"      Turn output on      ",
        "      Turn output off     "};
    private JButton button= new JButton(buttons[0]);
    private JLabel statusLabel= new JLabel("     furnace is off     ");
    
    private boolean status= false;  //status = "furnace is on"
    
    /** Constructor: a furnace, which relies on clock c. */
    public Furnace(SystemClock c) {
        super(c, "Furnace");
        Container cp= getContentPane();
        cp.add("North", statusLabel);
        cp.add("South", button);
        button.addActionListener(this);
        pack();
        move(290,100);
        show();
    }
    
    /** Turn the furnace off */
    public synchronized void turnOff() {
        status= false;
        statusLabel.setText("furnace is off");
    }
    
    /** Turn the furnace on */
    public synchronized void turnOn() {
        status= true;
        statusLabel.setText("furnace is on");
    }
    
    /** = 1 for "furnace on" and 0 for "Furnace off" */
    public synchronized double readValue() {
        if (status) return 1;
        return 0;
    }
    
    /** If a button was pressed, process it; otherwise, return result
        of super.action. The button is the output-toggle button */
    public void actionPerformed(ActionEvent e) {
        ThermoApplet.outputToggle= !ThermoApplet.outputToggle;
        if (ThermoApplet.outputToggle)
             button.setLabel(buttons[1]);
        else button.setLabel(buttons[0]);

    }
    
    /** If a button was pressed, process it; otherwise, return result
        of super.action. The button is the output-toggle button 
    public boolean action(Event e, Object arg) {
        if (arg.equals(button.getLabel())) {
            // Handle press of the output-toggle button
            ThermoApplet.outputToggle= !ThermoApplet.outputToggle;
            if (arg.equals(buttons[0]))
                button.setLabel(buttons[1]);
            else button.setLabel(buttons[0]);
            return true;
        }
        return super.action(e, arg);
    } */
}

