import java.awt.*;
import javax.swing.*;
import java.awt.event.*;

/** An instance of this class models the desired-temperature setting in
 a thermostat. An instance of this class has a window (a Frame) that
 displays the desired temperature. The desired temperature is changed
 by the user by typing in the textField and pressing a button. An
 instance has its own thread of execution. Its method run appears in
 superclass ClockedFrame. */

public class DesiredTemperature extends ClockedFrame implements ActionListener {
    JLabel label= new JLabel("Desired temperature:   ");
    JTextField textField= new JTextField();
    JButton button = new JButton("Read temperature");
    
    private double temperature; // Desired temperature
    
    /** Constructor: desired-temperature control, using clock c
     and with initial desired temperature t */
    public DesiredTemperature(SystemClock c, int t) {
        super(c, "Desired");
        temperature= t;
        Container cp= getContentPane();
        cp.add("North", label);
        cp.add("Center", textField);
        textField.setText("" + temperature);
        cp.add("South", button);
        button.addActionListener(this);
        pack();
        move(476, 100);
        show();
    }
    
    /** Return the desired temperature. */
    public synchronized double readValue() {    
        notifyAll();
        return(temperature);
    }
      
    /** If a button was pressed, process it; otherwise, return
     result of super.action. The only button is "Read temperature" */
    public void actionPerformed(ActionEvent e) {
        // Handle press of "Read temperature". Here, method getText
        // obtains the sequence of characters in component textField
        // on the Frame; trim removes whitespace at either end of
        // the String, and parseInt converts the String to an integer.
        String t= textField.getText().trim();
        temperature= Integer.parseInt(t);
    }
    
}



