import java.awt.* ;
import javax.swing.*;

/** A Frame that is a separate thread of execution. It uses a clock. */
public class ClockedFrame extends JFrame implements Runnable {
    
    protected String title;   // Title for the Frame
    protected Thread me;   // The name of its thread
    protected SystemClock clock; // The clock for the Frame
    
    /** Constructor: a Frame with title t that is connected to clock c.
     The contents of the Frame and showing it, etc., are done in
     subclasses. */
    public ClockedFrame(SystemClock c, String t) {
        super(t);
        clock= c;
        title= t;
    }
    
    /** Run this thread. This is the method required by interface
     Runnable. This method is invoked by method start() of class
     Thread to initiate execution. It loops forever: each iteration
     of the loop simply waits on the clock. */
    public void run() {
        me= Thread.currentThread();
        while(true) {
            synchronized(clock) {
                try {
                    clock.wait();
                }
                catch(InterruptedException ie) {
                    System.err.println("thread " + title + " interrupted, continuing...");
                }
            }
        }
    }
}

