/** An instance is a Token */
public class Token {

    /** These constants represent kinds of token. The name
        should tell you what the token is. */
    public static final int INTEGER= 0;
    public static final int PLUS= 1;
    public static final int MINUS= 2;
    public static final int MULT= 3;
    public static final int DIVIDE= 4;
    public static final int LPAREN= 5;
    public static final int RPAREN= 6;
    public static final int DOLLAR= 7;

    private int kind= 0;  // The token that this instance represents.
                          // -- one of the class constants
    private int value= 0; // If token = INTEGER, value contains its value

    /** Constructor: a token k (one of the class contants).
         If k = INTEGER, the value of the integer is 0 */
    public Token(int k){
        kind= k;
    }

    /** Constructor: a token k (one of the class contants).
        If k = INTEGER, the value of the integer is v */
    public Token (int k, int v){
        kind= k;
        value= v;
    }

    /** = the kind of this token (one of the class constants) */
    public int getKind() {
       return kind;
    }

    /** = the value of this token.
          Makes no sense if the kind is not INTEGER   */
    public int getValue() {
        return value;
    }

    /** = string representation of this token */
    public String toString() {
        if (kind == INTEGER) return "" + value;
        if (kind == PLUS) return "+";
        if (kind == MINUS) return "-";
        if (kind == MULT) return "*";
        if (kind == DIVIDE) return "/";
        if (kind == LPAREN) return "(";
        if (kind == RPAREN) return ")";
        if (kind == DOLLAR) return "$";
        // { An error if we reach here }
        return "";
    }
}
