
/** An instance is a "scanner" that reads a stream of characters from a source,
  creates "tokens" from it, and delivers tokens one at a time. Only one scanner
  should be in existence at one time because the class has some static variables
  and static methods.
  
  At any point, some token is being currently "processed". There are methods
  for obtaining this token and for deleting it from the source and thus making
  available the next token to be processed.
   */
public class Scan {
    
    private static Token tok;      // The current token being processed
    private static CS211In source; // The rest of the input to be processed
    
    /** = "print every token as it is scanned" */
    public static boolean tokenPrint= false;  
    
    /** Constructor: a Scanner that scans input s*/
    public Scan(CS211In s) { 
        source= s;
        tok= getNext();
    }
    
    /** remove the token currently being processed from the input source,
        change the token currently being processed to the next one in the source,
        and return the newly processed token.
     */
    private static Token getNext() { 
        switch(source.peekAtKind()) { 
            case CS211In.INTEGER:
                return new Token(Token.INTEGER,source.getInt());
                
            case CS211In.OPERATOR:
                char nextChar= source.getOp();
                switch(nextChar) { 
                case '+':return new Token(Token.PLUS);
                case '-':return new Token(Token.MINUS);
                case '*':return new Token(Token.MULT);
                case '/':return new Token(Token.DIVIDE);
                case '(':return new Token(Token.LPAREN);
                case ')':return new Token(Token.RPAREN);
                case '$':return new Token(Token.DOLLAR);
                default:throw new java.lang.NumberFormatException("operator not caught");
            }
                
            default:
                throw new java.lang.NumberFormatException("not INTEGER or OPERATOR");
        }
    }
    
    /** = the token currently being processed */
    public static Token getToken() { 
        return tok; 
    }
    
    /** Scan the next token of the input source, make it the current token,
        and return it. Print the token if the print-switch is true.
     */
    public static Token scan() {
        tok= getNext();
        if (tokenPrint) {
            System.out.println("next token is " + tok);
        }
        return tok;
    }
}


