/* This class provides a GUI: a window with several int fields, double 
 fields, and text fields. The current version has 3 int fields, 0 double
 fields, and 0 String fields. Change the constructor call in method main to
 change the number of fields. 
 
 Whenever the button in the window is pressed, method buttonPressed is called.
 Place code in this method to read the fields, calculate, and store values
 back in the fields. The current version adds the values in the first two int
 fields (numbers 0 and 1) and stores the sum in int fields number 2.
 */

import java.awt.*;
import java.io.*;

public class ExpProcessor extends JLiveWindow {
    
    
    /**  getIntField(i)     for the number in int    field i; 0 is first field
     *   getdoubleField(i)  for the number in double field i; 0 is first field
     *   getStringField(i)  for the number in String field i; 0 is first field
     *   setIntField(i,v);      to store int value v in field i
     *   setDoubleField(i,v);   to store double value v in field i
     *   setStringField(i,v);   to store String value v in field i */
    
    /** int field 0 is a command:<br>
     *  0: read an expression in the first String field.
           Parse the expression (followed by $).
           Put the value of the expression in the second int field.
           Store the tostring rep of the string in the second String field. 
           If '$' does not follow expression, put error message in fourth String field
        1: Toggle the "print all tokens switch" (initially off)*/
    public Object buttonPressed() {
        int command= getIntField(0);
        
        if (command == 0) { 
            StringReader sr= new StringReader(getStringField(0) + "$");
            CS211In input = new CS211In(sr);
            
            Scan myScanner = new Scan(input);
            Expression myExp = parseE();
            if (Scan.getToken().getKind() != Token.DOLLAR) {
                setStringField(3, "Error. $ does not follow parsed expression");
            }
            
            setIntField(1, myExp.eval());
            setStringField(1,myExp.toString());
        }
        
        if (command == 1) {
            Scan.tokenPrint= !Scan.tokenPrint;
            
        }
        
        if (Scan.tokenPrint) {
            setStringField(2, "Tokens printed when scanned.");
        }
        else {
            setStringField(2, "Tokens not printed when scanned.");
        }
        return null;
    }
    
    /** Create an instance of me and show it */
    public static void main(String args[]) {
        // The first argument to MyJLiveWindow is the number of int fields,
        // the second argument is the number of double fields, and
        // the third argument is the number of text (or String) fields.
        ExpProcessor testJLiveWindow= new ExpProcessor(2, 0, 4);
        testJLiveWindow.showWindow();
    }
    
    /** Create my window with
     max( min(i,MAX_FIELDS), 0) integer fields,
     max( min(d,MAX_FIELDS), 0) double fields, and
     max( min(s,MAX_FIELDS), 0) String fields
     and a "ready" button */
    public ExpProcessor(int i, int d, int s) {
        super(i, d, s);
    }
    
     /** Parse the E that begins with token scan.getToken() and return
     an Expression that represents it. When finished, the symbol following
     the E should be in scan.getToken().
     */
    public static Expression parseE(){ 
        Expression exp= parseT();
        Token token= Scan.getToken();
        int kind= token.getKind();
        // invariant: exp represents the expression parsed thus far,
        //            scan.getToken() contains the symbol following it,
        //            token is equal to scan.getToken(), and kind is its kind
        while (kind == Token.PLUS || kind == Token.MINUS) {
            Scan.scan();
            Expression right= parseT();
            exp= new BinOp(exp, token, right);
            token= Scan.getToken();
            kind= token.getKind();
        }
        return exp;
    }
    
     /** Parse the T that begins with token scan.getToken() and return
     an Expression that represents it. When finished, the symbol following
     the F should be in scan.getToken().
     */
    public static Expression parseT(){ 
        Expression exp= parseF();
        Token token= Scan.getToken();
        int kind= token.getKind();
        // invariant: exp represents the expression parsed thus far,
        //            scan.getToken() contains the symbol following it
        //            token is equal to scan.getToken, and kind is its kind
        while (kind == Token.MULT || kind == Token.DIVIDE) {
            Scan.scan();
            Expression right= parseF();
            exp= new BinOp(exp, token, right);
            token= Scan.getToken();
            kind= token.getKind();
        }
        return exp;
    }
    
        /** Parse the F that is starts with token scan.getToken and return an
        Expression that represents it. After parsing, the token that follows
        the parsed Expression should be in scan.getToken.
     */
    public static Expression parseF() {
        Token token= Scan.getToken();      // The token that is currently being processed
        int kindOfToken= token.getKind();  // The kind of the token currently being processed
        
        if (kindOfToken == Token.INTEGER) {
            int value= token.getValue();
            Scan.scan();
            return new Int(value); 
        }
        
        if (kindOfToken == Token.LPAREN) {
            Scan.scan();
            Expression exp= parseE();
            if (Scan.getToken().getKind() == Token.RPAREN) {
                Scan.scan();
            }
            else {
                System.out.println("Error. Missing right parenthesis. Next token is" + Scan.getToken());
            }
            return exp;  
        }
        
        if (kindOfToken == Token.MINUS) {
            Scan.scan();
            Expression factor= parseF();
            return new UnOp(factor);
        }
        
        // { Factor does not start with an integer, left paren, or minus sign }
        System.out.println("Error. Missing factor. Will use 0. Next token is" + Scan.getToken());
        return new Int(0);
    }
}

