/** An instance of the class represents a binary operation
    
      leftOp + rightOp,   leftOp - right Op
      leftOp * rightOp, or leftOp / rightOp
     */
public class BinOp extends Expression {
    
    /* leftOp contains the left operand;
     * op contains the operand --one of Token.PLUS, Token.MINUS,
     *     Token.MULT, or Token.DIVIDE;
     * rightOp contains the right operand.
     */
    private Expression leftOp;
    private Token op;
    private Expression rightOp;
    
    /** Constructor: an expression E of the form (leftOp op rightOp).
       op should be PLUS, MINUS, MULT, and DIVIDE of class Token */
    public BinOp(Expression leftOp, Token op, Expression rightOp) {
        this.leftOp= leftOp;
        this.op= op;
        this.rightOp= rightOp;
    }
    
    /** = A string representation of this E */
    public String toString() {
        return "(" + leftOp + " " + op + " " + rightOp + ")";
    }
    
    /** = the value of this expression binary operation E */
    public int eval() {
        if (op.getKind() == Token.PLUS)
            return leftOp.eval() + rightOp.eval();
        
        if (op.getKind() == Token.MINUS)
            return leftOp.eval() - rightOp.eval();
        
        if (op.getKind() == Token.MULT) {
            return leftOp.eval() * rightOp.eval();
        }
        
        // { op.getKind is Token.DIVIDE }
        int right= rightOp.eval();
        if (right != 0) {
            return leftOp.eval() / rightOp.eval();
        }
        else {
            System.out.println("Divisor in " + leftOp.eval() + 
                               " / 0 " + "is 0. Using 1 as the result.");
            return 1;
        }
    }
}
