/** Demo the use of Comparable */
public class CompDemo {
    
    /** Create an array of 8 shapes, print the array, sort
     the array, and print the array. */
    public static void main(String[] pars) {
        Shape[] sh= new Shape[8];
        
        sh[0]= new Circle(0);
        sh[1]= new Circle(1);
        sh[2]= new Circle(2);
        sh[3]= new Circle(3);
        
        sh[4]= new Square(0);
        sh[5]= new Square(1);
        sh[6]= new Square(2);
        sh[7]= new Square(4);
        
        System.out.println(toString(sh));
        selectionSort(sh);
        System.out.println(toString(sh));
    }
    
    /** =  the values of b, separated by , and delimited by [ and ] */
    public static String toString(Object[] b) {
        String res= "[";
        for (int k= 0; k != b.length; k= k+1) {
            if (k != 0) res= res + ", ";
            res= res + b[k];
        }
        return res + "]";
    }
    
    
    /** Given h < k, return the position of the minimum value of b[h..k] */
    public static int min(Comparable[] b, int h, int k) {
        int p= h; // will contain index of minimum
        int i= h;
        // {inv: b[p] is the minimum of b[h..i]}
        while (i!= k) {
            i= i+1;
            if (b[i].compareTo(b[p]) < 0)
            {p= i;}
        }
        return p;
    }
    
    /** Sort b --put its elements in ascending order */
    public static void selectionSort(Comparable[] b) {
        int j= 0;
        // {inv P: b[0..j-1] is sorted and b[0..j-1] <= b[j..]}
        while (j != b.length) {
            int p= min(b, j, b.length-1);
            // {b[p] is minimum of b[j..b.length-1]}
            // Swap b[j] and b[p]
            Comparable t= b[j]; b[j]= b[p]; b[p]= t;
            j= j+1;
        }
    }
}