import java.util.*;

/** An instance is a stack s of Objects, each of which is supposed to implement CompareTo */
public class Stack2 implements List211 {
    /** Stack s is in b[0..n-1], b[0] the bottom
        and b[n-1] the top element 
        The size of s is n.*/
    private Object[] b;
    private int n;
    private int N; // the maximum number of elements is s
    
    /** Constructor: an empty stack with max size m */
    public Stack2(int m) {
        b= new Object[m];
        n= 0;
        N= m;
    }
    
    /** Make the stack empty */
    public void makeEmpty() {
        n= 0;
    }

    /** add item e to the front of the stack.
        Throw RuntimeException if stack is full*/
    public void add(Object e) {
        if (n == b.length) {
            throw new RuntimeException(
                "Trying to add item to full stack");
        }
        b[n]= e; n= n+1;
    }
    
    /** delete an item from the front of the stack.
        Do nothing if the stack is empty*/
    public void delete() {
        if (n == 0)
            return;
        n= n-1;
    }
    
    /** = the front item of the stack.
          Throw a RuntimeException if stack is empty.*/
    public Object getItem() {
        if (n == 0) {
            throw new RuntimeException(
                "Trying to get item from empty stack");
        } 
        return b[n-1];
    }
    
    /** = the number of items in the stack */
    public int size() {
        return n;   
    }
    
    
    /** = elements of stack from top to bottom, separated
          by commas and delimited by [ and ] */
    public String toString() {
        String res= "[";
        Iterator it= getEnumerator();
        while (it.hasNext()) {
            if (res.length() > 1) 
                res= res + ",";
            res= res + it.next();
        }
        return res + "]";
    }
    
    /** = an enumerator of the stack elements, from top to bottom */
    public Iterator getEnumerator() {
        return new EnumStack();
    }
    
    /** An enumerator over the elements of this stack, from top to bottom */
    private class EnumStack implements Iterator {
        private int k= n-1;  //Index of next item to enumerate (-1 if none)
        
        /** = "there is another item to enumerate" */
        public boolean hasNext() {
            return k >= 0;
        }
        
        /** = the next item to be enumerated.
              Throw NoSuchElementException if none*/
        public Object next() {
            if (k < 0)
                throw new NoSuchElementException("no element in this stack");
            k= k-1;
            return b[k+1];
        }
        
        /** Not implemented. Throw UnsupportedOperationException */
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove from this stack");
        }
    }
    
}